/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.common.collection.CdSetList;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.colors.OlapBuilderColors;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderStatisticalDimension;
import crazydev.iccube.builder.model.impl.localization.OlapBuilderLocalization;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderViewCycleDetector;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.UxResultDockType;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.dimension.UxBrowseSchemaDimensionQuery;
import crazydev.iccube.ux.builder.queries.dimension.UxBrowseSchemaDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionBrowse;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.mdx.queries.browser.result.UxSchemaBrowsingTree;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UxDimensionBrowseQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderDimensionUniqueName dimensionName;

    public UxDimensionBrowseQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderDimensionUniqueName dimensionName) {
        super(meta, requestId, schemaId);
        this.dimensionName = dimensionName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        service.removeSchemaDefinition(this.schemaId);
        OlapSchemaFactoryInfo info = service.getSchemaShortInfo(this.schemaId, false);
        File xmlFile = info.getFile();
        return service.readSchemaClone(this.schemaId, -1, (lock, schema) -> {
            UxResultDockName dockName = new UxResultDockName(UxResultDockType.DIMENSION_BROWSE, this.dimensionName.getDimensionName(), this.dimensionName.getDimensionName());
            try {
                OlapSchema fakeSchema = this.setupFakeSchema(queryContext, lock, schema, xmlFile);
                String treeId = fakeSchema.getUuid();
                String schemaDimensionName = fakeSchema.getName();
                UxAction browse = UxBrowseSchemaDimensionQueryMeta.createAction(queryContext, this.schemaId, schemaDimensionName, treeId);
                UxSchemaBrowsingTree iTree = UxBrowseSchemaDimensionQuery.fetchTree(queryContext, fakeSchema, treeId, schemaDimensionName, null);
                return UxReply.actionSuccess((UxActionResult)new UxDimensionBrowse(this.dimensionName.getDimensionName(), fakeSchema.getUuid(), browse, iTree), dockName);
            }
            catch (OlapContextualBigException ex) {
                OlapLoggers.BUILDER.error((Object)"[builder] validation error(s)", (Throwable)ex);
                List exErrors = ex.getErrors();
                UxValidationResult errors = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), exErrors);
                return UxReply.validationErrors(errors);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchema setupFakeSchema(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, File xmlFile) throws OlapContextualBigException {
        OlapSchema fakeSchema;
        Set<Object> dsTables;
        IOlapBuilderDataSource dataSource;
        CdSetList tables;
        String id;
        String id2;
        IOlapBuilderTabularDataDef dimensionTabularData;
        OlapBuilderSchema schemaDef = schema.getDefinition(lock);
        IOlapBuilderDimensionDef dimensionDef = schema.getExistingDimension(lock, this.dimensionName);
        IOlapBuilderLocalizationDef localizationDef = schema.getLocalization(lock);
        IOlapBuilderColorsDef colorsDef = schema.getColors(lock);
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
        OlapBuilderReferenceSolver solver = OlapBuilderSchemaMain.createReferenceSolver((OlapBuilderErrorManager)errorManager, (IOlapBuilderSchemaDef)schemaDef);
        IOlapBuilderTabularDataDef iOlapBuilderTabularDataDef = dimensionTabularData = dimensionDef instanceof OlapBuilderStatisticalDimension ? null : solver.getTabularData(dimensionDef.getDataTableId());
        IOlapBuilderTabularDataDef localizationDefTabularData = localizationDef != null && localizationDef.isEnabled() ? ((id2 = localizationDef.getDataTableId()) != null ? solver.getTabularData(id2) : null) : null;
        IOlapBuilderTabularDataDef colorsDefTabularData = colorsDef != null && colorsDef.isEnabled() ? ((id = colorsDef.getDataTableId()) != null ? solver.getTabularData(id) : null) : null;
        if (dimensionTabularData instanceof OlapBuilderBaseDataView) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schemaDef, (IOlapBuilderDataViewDef)((IOlapBuilderDataViewDef)dimensionTabularData));
        }
        if (localizationDefTabularData instanceof OlapBuilderBaseDataView) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schemaDef, (IOlapBuilderDataViewDef)((IOlapBuilderDataViewDef)localizationDefTabularData));
        }
        if (colorsDefTabularData instanceof OlapBuilderBaseDataView) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schemaDef, (IOlapBuilderDataViewDef)((IOlapBuilderDataViewDef)colorsDefTabularData));
        }
        HashMap allRequiredDataTables = new HashMap();
        if (dimensionTabularData != null) {
            dimensionTabularData.solveReferences(solver, new OlapBuilderViewCycleDetector());
            tables = dimensionTabularData.getUnderlyingTables();
            for (IOlapBuilderDataTableDef table : tables) {
                dataSource = table.getDataSource();
                dsTables = (HashSet<IOlapBuilderDataTableDef>)allRequiredDataTables.get(dataSource);
                if (dsTables == null) {
                    dsTables = new HashSet<IOlapBuilderDataTableDef>();
                    allRequiredDataTables.put(dataSource, dsTables);
                }
                dsTables.add(table);
            }
        }
        if (localizationDefTabularData != null) {
            localizationDefTabularData.solveReferences(solver, new OlapBuilderViewCycleDetector());
            tables = localizationDefTabularData.getUnderlyingTables();
            for (IOlapBuilderDataTableDef table : tables) {
                dataSource = table.getDataSource();
                dsTables = (Set)allRequiredDataTables.get(dataSource);
                if (dsTables == null) {
                    dsTables = new HashSet();
                    allRequiredDataTables.put(dataSource, dsTables);
                }
                dsTables.add(table);
            }
        }
        if (colorsDefTabularData != null) {
            colorsDefTabularData.solveReferences(solver, new OlapBuilderViewCycleDetector());
            tables = colorsDefTabularData.getUnderlyingTables();
            for (IOlapBuilderDataTableDef table : tables) {
                dataSource = table.getDataSource();
                dsTables = (Set)allRequiredDataTables.get(dataSource);
                if (dsTables == null) {
                    dsTables = new HashSet();
                    allRequiredDataTables.put(dataSource, dsTables);
                }
                dsTables.add(table);
            }
        }
        HashSet requiredViews = new HashSet();
        if (dimensionTabularData != null) {
            requiredViews.addAll(dimensionTabularData.getAllViews());
        }
        if (localizationDefTabularData != null) {
            requiredViews.addAll(localizationDefTabularData.getAllViews());
        }
        if (colorsDefTabularData != null) {
            requiredViews.addAll(colorsDefTabularData.getAllViews());
        }
        String root = "Dimension " + dimensionDef.getName();
        OlapBuilderSchema fakeSchemaDef = new OlapBuilderSchema(root, root, root);
        fakeSchemaDef.setForFakeSchema(schema.getFactory(), dimensionDef);
        fakeSchemaDef.setSchemaLocalizationFallbackLocale(schemaDef.getSchemaLocalizationFallbackLocale());
        fakeSchemaDef.setMembersUpperLowerCaseStrategy(schemaDef.membersUpperLowerCaseStrategy());
        if (localizationDef != null) {
            fakeSchemaDef.setLocalization(localizationDef);
        } else {
            fakeSchemaDef.setLocalization((IOlapBuilderLocalizationDef)new OlapBuilderLocalization(false));
        }
        if (colorsDef != null) {
            fakeSchemaDef.setColors(colorsDef);
        } else {
            fakeSchemaDef.setColors((IOlapBuilderColorsDef)new OlapBuilderColors(false));
        }
        fakeSchemaDef.setViews(requiredViews);
        fakeSchemaDef.setLocaleForStringCompare(schemaDef.getLocaleForStringCompare());
        for (Map.Entry entry : allRequiredDataTables.entrySet()) {
            IOlapBuilderDataSource requiredDataSource = (IOlapBuilderDataSource)entry.getKey();
            Set requiredDataTables = (Set)entry.getValue();
            IOlapBuilderDataSource clone = requiredDataSource.cloneForDimensionBrowsing(requiredDataTables);
            fakeSchemaDef.addDataSource(clone);
        }
        OlapBuilderSchemaDefFactory fakeSchemaFactory = new OlapBuilderSchemaDefFactory(fakeSchemaDef);
        fakeSchemaFactory.setXmlFile(xmlFile);
        OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapProperties olapProperties = olapEngineRequestContext.getOlapEngineProperties();
        OlapFunctionRepository functionRepository = olapEngine.getFunctionRepository();
        OlapEngineRequestContext olapEngineRequestContext2 = context.getOlapEngineRequestContext();
        String snapshot = context.getBuilderSnapshot();
        OlapEngineLoadSchemaParams params = new OlapEngineLoadSchemaParams(fakeSchemaFactory.getXmlFile(), false, -1, -1, snapshot != null ? OlapEngineOfflineMode.READ : OlapEngineOfflineMode.OFF, snapshot, false);
        try {
            olapEngineRequestContext2.setupBuilderLoadExecutors(false);
            fakeSchema = OlapBuilderSchemaMain.create((OlapEngineRequestContext)olapEngineRequestContext2, (IOlapEngineLoadSchemaParams)params, (OlapProperties)olapProperties, (OlapFunctionRepository)functionRepository, (boolean)false, (IOlapBuilderSchemaDefFactory)fakeSchemaFactory);
            Logger logger = olapEngineRequestContext2.getLoggers().builder();
            try {
                OlapSchemaLocalization localization = fakeSchema.getLocalization();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[schema] schema [" + fakeSchema.getName() + "] localization post-processing started"));
                }
                localization.resolveLocalisationKeys(logger, fakeSchema);
            }
            finally {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[schema] schema [" + fakeSchema.getName() + "] localization post-processing done"));
                }
            }
        }
        finally {
            olapEngineRequestContext2.releaseBuilderLoadExecutors(false);
        }
        context.getSessionContext().addToCache(new IcCubeServerSessionContext.SoftKey(fakeSchema.getUuid()), fakeSchema);
        return fakeSchema;
    }
}

