/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dataview.create;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.ux.meta.UxBuilderMetaInfo;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewType;
import crazydev.iccube.builder.ux.meta.dataview.wizard.UxBuilderCreateDataViewWizard;
import crazydev.iccube.builder.ux.meta.dataview.wizard.UxBuilderCreateDataViewWizardSteps;
import crazydev.iccube.builder.ux.meta.dataview.wizard.UxBuilderDataViewTypeForm;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.UxBuilderDataViewTypeFormModelType;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefValidation;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.type.UxEnumValue;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxValidateDataViewWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;
    private final int activeStep;

    public UxValidateDataViewWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels, int activeStep) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
        this.activeStep = activeStep;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderCreateDataViewWizard wizard = UxWizardDef.setupCreateDataViewWizardFromJson(queryContext, this.props, this.activeStep, this.stepDefs, this.stepModels);
            this.setModelTypesSetupInfoForDataView(queryContext, lock, schema, true);
            UxBuilderWizardValidation validation = this.validate(queryContext, wizard, this.activeStep);
            UxWizardDefValidation validationUI = this.setupWizardValidationUI(queryContext, validation);
            return UxReply.actionSuccess(validationUI);
        });
    }

    private UxBuilderWizardValidation validate(UxQueryContext queryContext, UxBuilderCreateDataViewWizard wizard, int activeStep) {
        List steps = wizard.getSteps();
        UxBuilderDataViewTypeForm typeFORM = (UxBuilderDataViewTypeForm)((UxBuilderWizardStep)steps.get(0)).getModel();
        String viewType = typeFORM.getViewType();
        try {
            UxBuilderMetaInfo meta = queryContext.getBuilderMetaInfo();
            UxBuilderDataViewType dataViewType = meta.getDataViewType(viewType);
            if (dataViewType == null) {
                throw new RuntimeException("unexpected missing view type [" + viewType + "]");
            }
            IOlapBuilderDataViewDef view = dataViewType.newInstance();
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            newSteps.add(UxBuilderCreateDataViewWizardSteps.createView((IOlapBuilderDataViewDef)view));
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxEnumValue viewTypeE = UxBuilderDataViewTypeFormModelType.setupType(queryContext, new UxBuilderDataViewType(view.getClass()));
            String caption = viewTypeE.getCaption();
            String useCase = babylon.translateUseCaseCaption(UxBuilderUseCaseName.CreateDataView.name(), new Serializable[0]);
            String type = CdStringUtils.isNotNullAndNotBlank((String)caption) ? " : " + caption : null;
            return new UxBuilderWizardValidation(activeStep, newSteps, useCase + type);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            OlapLoggers.BUILDER.error((Object)("unexpected data-view type [" + viewType + "]"), (Throwable)ex);
            throw new RuntimeException("unexpected data-view type [" + viewType + "]", ex);
        }
    }
}

