/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dataview;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaUsageHelper;
import crazydev.iccube.ux.builder.model.UxBuilderTabularDataUsage;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTablesQuery;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewsQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxDataViewsQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxDataViewsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableHeaders header = UxTableHeaders.create(babylon, "name", "description", "type", "usedByEx");
            UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IOlapBuilderDataViewDef>("name", babylon.translate("filterDataViewName", new Serializable[0]), IOlapBuilderNamedDef::getName), new UxFilterMeta<IOlapBuilderDataViewDef>("description", babylon.translate("filterDataViewDescription", new Serializable[0]), IOlapBuilderTabularDataDef::getDescription));
            UxTableRowSearcher<IOlapBuilderDataViewDef> searcher = new UxTableRowSearcher<IOlapBuilderDataViewDef>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean isAccepting(IOlapBuilderDataViewDef row, String searchText) {
                    return this.isContaining(searchText, row.getName());
                }
            };
            ArrayList views_ = new ArrayList();
            schema.forEachView(lock, views_::add);
            List<IOlapBuilderDataViewDef<?>> views = this.filter(this.tableOptions, searcher, filterMetas, views_);
            UxBuilderTabularDataUsage usages = UxBuilderSchemaUsageHelper.getUsageAllViews(lock, schema, views);
            int totalRowCount = views.size();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "name", UxTableSortType.asc, totalRowCount));
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            for (IOlapBuilderDataViewDef<?> view : views) {
                rows.add(UxDataViewsQuery.createRow(queryContext, this.schemaId, schema, usages, view));
            }
            List<UxAction> multiSelectionActions = UxDataViewsQueryMeta.createMultiSelectionActions(queryContext, this.schemaId);
            UxTable table = UxTable.create(options, header, rows, multiSelectionActions);
            UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
            return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
        });
    }

    private static UxTableRow createRow(UxQueryContext context, UxSchemaId schemaId, UxBuilderSchema schema, UxBuilderTabularDataUsage usages, IOlapBuilderDataViewDef view) {
        List<IOlapBuilderUsedByDef> usedBy = !usages.isNotUsed(view.getId()) ? usages.getUsedBy(view.getId()) : null;
        OlapBabylonService babylon = context.getOlapBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(view.getName()));
        cells.add(new UxTableCell(view.getDescription()));
        cells.add(new UxTableCell(babylon.translateUiModelTypeLabel(view.getClass().getName())));
        cells.add(new UxTableCell(UxDataTablesQuery.createUsedByCaption0(context, usedBy)));
        UxTableRow row = new UxTableRow(cells);
        String schemaName = schema != null ? schema.getName() : null;
        row.setUseCase(UxDataViewQueryMeta.createUseCase(context, schemaId, schemaName, view.getId(), view.getName(), view.getHelpUrl()));
        row.getCells().get(3).setUseCase(UxDataTablesQuery.createUsedByUseCase0(context, schemaId, usedBy));
        return row;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.DataViews, this.schemaId));
    }
}

