/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dataview;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datatable.UxDuplicateTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.analyse.UxTableAnalyseQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTableBrowseQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.export.UxExportTableCSVQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.export.UxExportTableXLSQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.process.UxProcessTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.switch_.UxSwitchTableQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQuery;
import crazydev.iccube.ux.builder.queries.dataview.UxDeleteDataViewQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxRefreshDataViewColumnsQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDataViewQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxDataViewQueryMeta DataView = new UxDataViewQueryMeta();

    protected UxDataViewQueryMeta() {
        super(UxConsoleConstants.QueryName.DataView);
    }

    @Override
    @Nullable
    public UxUrl helpUrl() {
        return null;
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        String viewName = params.getExistingStringParameter("viewName");
        return new UxDataViewQuery(this, params.getRequestId(), schemaId, viewName);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, String viewName) {
        return this.createQueryUrl(schemaId).addParam("viewName", viewName);
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, @Nullable String schemaName, @Nullable String uuid, String viewName, @Nullable String viewHelpUrl) {
        List<UxAction> actions = DataView.createActions(context, schemaId);
        schemaName = schemaName != null ? schemaName : schemaId.schemaName;
        actions.add(UxRefreshDataViewColumnsQueryMeta.createAction(context, schemaId, viewName));
        if (schemaName != null && uuid != null) {
            actions.add(UxSwitchTableQueryMeta.createAction(context, schemaId, schemaName, uuid));
        }
        actions.add(UxTableBrowseQueryMeta.createActionForView(context, schemaId, viewName));
        actions.add(UxTableAnalyseQueryMeta.createActionForView(context, schemaId, viewName));
        actions.add(UxExportTableXLSQueryMeta.createActionForView(context, schemaId, viewName));
        actions.add(UxExportTableCSVQueryMeta.createActionForView(context, schemaId, viewName));
        actions.add(UxProcessTableQueryMeta.createActionForView(context, schemaId, viewName));
        actions.add(UxDuplicateTableQueryMeta.createActionForView(context, schemaId, viewName));
        actions.add(UxDeleteDataViewQueryMeta.createAction(context, schemaId, viewName));
        UxUrl url = DataView.createQueryUrl(schemaId, viewName);
        UxUrl helpUrl = CdStringUtils.isNotNullAndNotBlank((String)viewHelpUrl) ? UxUrlConstants.APP_URL_HELP_ROOT.addParam("ic3topic", "server.user_guide.schemas_cubes." + viewHelpUrl) : null;
        return new UxUseCaseBuilder(context, DataView, schemaId).withId(UxBuilderUseCaseName.DataView, viewName).withUUID(uuid).withUrl(url).withHelpUrl(helpUrl != null ? helpUrl.toUrl() : null).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxBuilderUseCaseName.DataViews, schemaId), viewName, viewName, UxAdminUseCaseRepository.asBookmark(url))).withActions(actions).build(true);
    }
}

