/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.switch_;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSwitchTableQuery
extends UxSchemaBuilderQuery {
    private final String fromTableUUID;
    private final String toTableUUID;

    public UxSwitchTableQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String fromTableUUID, String toTableUUID) {
        super(meta, requestId, schemaId);
        this.fromTableUUID = fromTableUUID;
        this.toTableUUID = toTableUUID;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderTabularDataDef fromTable = schema.getTabularData(lock, this.fromTableUUID);
            if (fromTable == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"table/view", this.fromTableUUID}));
            }
            IOlapBuilderTabularDataDef toTable = schema.getTabularData(lock, this.toTableUUID);
            if (toTable == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"table/view", this.toTableUUID}));
            }
            schema.switchTabularDataUsage(lock, fromTable, toTable);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "switch table: " + fromTable.getName() + " to: " + toTable.getName());
            return UxReply.actionSuccess();
        });
    }
}

