/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.refresh;

import crazydev.iccube.builder.model.status.OlapBuilderDataColumnRefreshStatus;
import crazydev.iccube.builder.model.status.OlapBuilderDataTableRefreshStatus;
import crazydev.iccube.builder.model.status.OlapBuilderRefreshStatusKind;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.queries.datatable.UxTableColumnRefresh;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxTableRefreshKind;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTableRefresh
implements UxSerializable {
    private final String statusCaption;
    private final String tableName;
    @Nullable
    private final List<UxTableColumnRefresh> columns;
    @Nullable
    private final UxValidationMessage error;

    private UxTableRefresh(String statusCaption, String tableName, @Nullable List<UxTableColumnRefresh> columns, @Nullable UxValidationMessage error) {
        this.statusCaption = statusCaption;
        this.tableName = tableName;
        this.columns = columns;
        this.error = error;
    }

    public static UxTableRefresh create(UxBabylonService babylon, String tableName, List<UxTableColumnRefresh> columns) {
        return new UxTableRefresh(babylon.translate("refresh_StatusCaption", new Serializable[0]), tableName, columns, null);
    }

    public static UxTableRefresh create(UxBabylonService babylon, String tableName, UxValidationMessage error) {
        return new UxTableRefresh(babylon.translate("refresh_StatusCaption", new Serializable[0]), tableName, null, error);
    }

    @Nullable
    public static UxTableRefresh create(UxBabylonService babylon, OlapBuilderDataTableRefreshStatus status) {
        OlapBuilderRefreshStatusKind kind = status.getStatus();
        if (kind == OlapBuilderRefreshStatusKind.UNCHANGED) {
            return null;
        }
        ArrayList<UxTableColumnRefresh> columns = new ArrayList<UxTableColumnRefresh>();
        for (OlapBuilderDataColumnRefreshStatus column : status.getColumns()) {
            if (column.getStatus() == OlapBuilderRefreshStatusKind.UNCHANGED) continue;
            columns.add(UxTableColumnRefresh.create(babylon, column.getName(), UxTableRefreshKind.valueOf(column.getStatus()), column.getTypeFrom(), column.getTypeTo()));
        }
        if (!columns.isEmpty()) {
            return UxTableRefresh.create(babylon, status.getName(), columns);
        }
        return null;
    }

    public boolean isUpdated() {
        if (this.error != null) {
            return true;
        }
        if (this.columns != null) {
            for (UxTableColumnRefresh column : this.columns) {
                if (!column.isUpdated()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasError() {
        return this.error != null;
    }
}

