/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.refresh;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.status.OlapBuilderDataColumnRefreshStatus;
import crazydev.iccube.builder.model.status.OlapBuilderDataTableRefreshStatus;
import crazydev.iccube.builder.model.status.OlapBuilderRefreshStatusKind;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxDataSourceRefresh;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxDataSourcesRefresh;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxTableRefresh;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxRefreshTableHelper {
    private UxRefreshTableHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxDataSourcesRefresh refresh(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable IOlapBuilderDataSource dataSource, @Nullable IOlapBuilderDataTableDef table) {
        block9: {
            if (table != null && dataSource == null) {
                throw new RuntimeException("internal error: missing data source for table [" + table.getName() + "]");
            }
            if (table != null) {
                try (IOlapBuilderConnection connection = dataSource.createConnection(queryContext.asRuntimeContext(), true);){
                    connection.open(queryContext.asRuntimeContext());
                    boolean changedPersistency = dataSource.refreshCachedEntities(connection);
                    UxTableRefresh status = UxRefreshTableHelper.refreshTable(queryContext, connection, lock, schema, dataSource, table);
                    if (changedPersistency || status != null) {
                        UxDataSourcesRefresh uxDataSourcesRefresh = UxDataSourcesRefresh.create(queryContext.getUxBabylonService(), UxDataSourceRefresh.create(queryContext.getUxBabylonService(), dataSource.getName(), status, changedPersistency));
                        return uxDataSourcesRefresh;
                    }
                    break block9;
                }
            }
            if (dataSource != null) {
                UxDataSourceRefresh status = UxRefreshTableHelper.refreshDataSource(queryContext, lock, schema, dataSource);
                if (status != null) {
                    return UxDataSourcesRefresh.create(queryContext.getUxBabylonService(), status);
                }
            } else {
                return UxRefreshTableHelper.refreshDataSources(queryContext, lock, schema, schema.getDataSources(lock));
            }
        }
        return null;
    }

    @Nullable
    private static UxDataSourcesRefresh refreshDataSources(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, List<IOlapBuilderDataSource> dataSources) {
        ArrayList<UxDataSourceRefresh> status = new ArrayList<UxDataSourceRefresh>();
        for (IOlapBuilderDataSource dataSource : dataSources) {
            UxDataSourceRefresh dataSourceStatus = UxRefreshTableHelper.refreshDataSource(context, lock, schema, dataSource);
            if (dataSourceStatus == null) continue;
            status.add(dataSourceStatus);
        }
        if (!status.isEmpty()) {
            return UxDataSourcesRefresh.create(context.getUxBabylonService(), status);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static UxDataSourceRefresh refreshDataSource(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataSource dataSource) {
        ArrayList<UxTableRefresh> status = new ArrayList<UxTableRefresh>();
        try (IOlapBuilderConnection connection = dataSource.createConnection(context.asRuntimeContext(), true);){
            Object object;
            connection.open(context.asRuntimeContext());
            boolean changedPersistency = dataSource.refreshCachedEntities(connection);
            List tables = dataSource.getTables();
            for (IOlapBuilderDataTableDef table : tables) {
                UxTableRefresh tableStatus = UxRefreshTableHelper.refreshTable(context, connection, lock, schema, dataSource, table);
                if (tableStatus == null) continue;
                status.add(tableStatus);
            }
            if (changedPersistency || !status.isEmpty()) {
                object = UxDataSourceRefresh.create(context.getUxBabylonService(), dataSource.getName(), status, changedPersistency);
                return object;
            }
            object = null;
            return object;
        }
    }

    @Nullable
    private static UxTableRefresh refreshTable(UxQueryContext context, IOlapBuilderConnection connection, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataSource dataSource, IOlapBuilderDataTableDef table) {
        if (OlapLoggers.UX_REQUEST.isDebugEnabled()) {
            OlapLoggers.UX_REQUEST.debug((Object)("[UX] table [" + table.getName() + "] [" + dataSource.getName() + "] refreshing..."));
        }
        table.setDataSource(dataSource);
        if (!UxRefreshTableHelper.isTableExist(connection, table)) {
            if (OlapLoggers.UX_REQUEST.isDebugEnabled()) {
                OlapLoggers.UX_REQUEST.debug((Object)" -- missing");
            }
            return UxTableRefresh.create(context.getUxBabylonService(), table.getName(), UxUtils.setupValidationMessage(context, context.getOlapBabylonService(), OlapBuilderError.create((CdErrorCode)OlapBuilderErrorCode.TABLE_MISSING, (Serializable[])new Serializable[0])));
        }
        OlapBuilderErrorManager errManager = new OlapBuilderErrorManager(true);
        try {
            errManager.pushContext((IOlapContextual)schema.getFactory());
            errManager.pushContext((IOlapContextual)dataSource);
            if (table instanceof OlapBuilderBaseDataTable) {
                return UxRefreshTableHelper.refreshColumns(context, errManager, connection, (OlapBuilderBaseDataTable)table);
            }
            return null;
        }
        catch (OlapBuilderErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] table [" + table.getName() + "] refresh error"), (Throwable)ex);
            UxValidationMessage message = UxUtils.setupValidationMessage(context, context.getOlapBabylonService(), (CdError)ex.getError());
            return UxTableRefresh.create(context.getUxBabylonService(), table.getName(), message);
        }
    }

    private static boolean isTableExist(IOlapBuilderConnection connection, IOlapBuilderDataTableDef table) {
        OlapBuilderBaseDataSource datasource = (OlapBuilderBaseDataSource)connection.getDataSource();
        if (datasource.isDiscoverTablesSupported() && table.isDiscoveredInDataSource()) {
            String fileName = table.getFileName();
            List tableNames = datasource.discoverAllTablesNames(connection, false, fileName);
            boolean found = false;
            for (String tableName : tableNames) {
                if (!tableName.equalsIgnoreCase(fileName)) continue;
                found = true;
                break;
            }
            return found;
        }
        return true;
    }

    @Nullable
    private static UxTableRefresh refreshColumns(UxQueryContext context, OlapBuilderErrorManager errorManager, IOlapBuilderConnection connection, OlapBuilderBaseDataTable table) {
        OlapBuilderDataTableRefreshStatus status = new OlapBuilderDataTableRefreshStatus(table.getName());
        List newColumns = table.discoverAllColumnsForRefresh(context.asRuntimeContext(), connection, errorManager);
        if (newColumns != null) {
            for (int newColumnPos = 0; newColumnPos < newColumns.size(); ++newColumnPos) {
                Integer columnPos;
                IOlapBuilderDataColumnDef newColumn = (IOlapBuilderDataColumnDef)newColumns.get(newColumnPos);
                OlapBuilderDataColumnRefreshStatus columnStatus = new OlapBuilderDataColumnRefreshStatus(newColumn.getName());
                IOlapBuilderDataColumnDef column = table.lookupColumn(newColumn);
                if (column != null) {
                    newColumn.updateFrom(column, columnStatus);
                    if (OlapLoggers.UX_REQUEST.isDebugEnabled()) {
                        OlapLoggers.UX_REQUEST.debug((Object)(" -- column (u) [" + newColumn.getName() + "] " + String.valueOf(columnStatus.getStatus())));
                    }
                } else {
                    columnStatus.setStatus(OlapBuilderRefreshStatusKind.ADDED);
                    newColumn.setSelected(true);
                    if (OlapLoggers.UX_REQUEST.isDebugEnabled()) {
                        OlapLoggers.UX_REQUEST.debug((Object)(" -- column (a) [" + newColumn.getName() + "] " + String.valueOf(columnStatus.getStatus())));
                    }
                }
                if (column != null && columnStatus.getStatus() == OlapBuilderRefreshStatusKind.UNCHANGED && table.isColumnPositionRelevant() && (columnPos = table.lookupColumnPosition(newColumn)) != null && columnPos != newColumnPos) {
                    columnStatus.setStatus(OlapBuilderRefreshStatusKind.UPDATED);
                    columnStatus.setTypeFrom("pos:" + columnPos);
                    columnStatus.setTypeTo("pos:" + newColumnPos);
                }
                if (columnStatus.getStatus() == OlapBuilderRefreshStatusKind.UNCHANGED) continue;
                status.addColumnStatus(columnStatus);
            }
            ArrayList deletedColumns = new ArrayList(table.getAllColumns());
            deletedColumns.removeAll(newColumns);
            for (IOlapBuilderDataColumnDef column : deletedColumns) {
                OlapBuilderDataColumnRefreshStatus columnStatus = new OlapBuilderDataColumnRefreshStatus(column.getName());
                columnStatus.setStatus(OlapBuilderRefreshStatusKind.DELETED);
                if (OlapLoggers.UX_REQUEST.isDebugEnabled()) {
                    OlapLoggers.UX_REQUEST.debug((Object)(" -- column (d) [" + column.getName() + "] " + String.valueOf(columnStatus.getStatus())));
                }
                status.addColumnStatus(columnStatus);
            }
            table.resetColumns(newColumns);
        }
        return UxTableRefresh.create(context.getUxBabylonService(), status);
    }
}

