/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.refresh;

import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxDataSourceRefresh;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDataSourcesRefresh
extends UxActionResult {
    private final String dataSourceCaption;
    private final List<UxDataSourceRefresh> dataSources;
    @Nullable
    private UxActionContinuationKind continuation;

    private UxDataSourcesRefresh(String dataSourcesCaption, List<UxDataSourceRefresh> dataSources) {
        this.dataSourceCaption = dataSourcesCaption;
        this.dataSources = dataSources;
    }

    public static UxDataSourcesRefresh create(UxBabylonService babylon, UxDataSourceRefresh dataSource) {
        return UxDataSourcesRefresh.create(babylon, Collections.singletonList(dataSource));
    }

    public static UxDataSourcesRefresh create(UxBabylonService babylon, List<UxDataSourceRefresh> dataSources) {
        return new UxDataSourcesRefresh(babylon.translate("refresh_dataSourceCaption", new Serializable[0]), dataSources);
    }

    public UxDataSourcesRefresh withContinuation(UxActionContinuationKind continuation) {
        this.continuation = continuation;
        return this;
    }

    public boolean isUpdated() {
        for (UxDataSourceRefresh dataSource : this.dataSources) {
            if (!dataSource.isUpdated()) continue;
            return true;
        }
        return false;
    }

    public boolean hasError() {
        for (UxDataSourceRefresh dataSource : this.dataSources) {
            if (!dataSource.hasError()) continue;
            return true;
        }
        return false;
    }
}

