/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.process;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.process.UxProcessTableQuery;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxProcessTableQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxProcessTableQueryMeta ProcessTable = new UxProcessTableQueryMeta();

    protected UxProcessTableQueryMeta() {
        super(UxConsoleConstants.QueryName.ProcessTable);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        UxBuilderTablePathName tableName = params.getTableNameParameter("tableName");
        String viewName = params.getStringParameter("viewName");
        if (tableName == null && CdStringUtils.isNullOrBlank((String)viewName)) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{"tableName|viewName"});
        }
        if (tableName != null) {
            return new UxProcessTableQuery((UxQueryMeta)this, params.getRequestId(), schemaId, tableName);
        }
        return new UxProcessTableQuery((UxQueryMeta)this, params.getRequestId(), schemaId, viewName);
    }

    @Nullable
    public static UxAction createActionForTable(UxQueryContext context, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, ProcessTable, schemaId).withOkCancel().withParams(new UxField(babylon, "tableName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(tableName.asUrlParam()))).withContinuation(UxActionContinuationKind.RESULT).build();
    }

    @Nullable
    public static UxAction createActionForView(UxQueryContext context, UxSchemaId schemaId, String viewName) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, ProcessTable, schemaId).withOkCancel().withParams(new UxField(babylon, "viewName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(viewName))).withContinuation(UxActionContinuationKind.RESULT).build();
    }
}

