/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.process;

import crazydev.common.utils.CdMutableInt;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.executor.common.OlapBuilderTableHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxProcessTableQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxBuilderTablePathName tableName;
    @Nullable
    private final String viewName;

    public UxProcessTableQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        super(meta, requestId, schemaId);
        this.tableName = tableName;
        this.viewName = null;
    }

    public UxProcessTableQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName) {
        super(meta, requestId, schemaId);
        this.tableName = null;
        this.viewName = viewName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        if (this.tableName == null && CdStringUtils.isNullOrBlank((String)this.viewName)) {
            return UxReply.actionSuccess(new UxActionStatus(babylon.translate("readTableDoneNone", Integer.valueOf(0))));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchemaClone(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataViewDef data;
            if (this.tableName != null) {
                UxBuilderTableReference table = schema.getDataTable(lock, this.tableName);
                if (table != null) {
                    table.table.setDataSource(table.dataSource);
                    data = table.table;
                } else {
                    data = null;
                }
            } else {
                data = schema.getDataViewByName(lock, this.viewName);
            }
            if (data == null) {
                return UxReply.actionSuccess(new UxActionStatus(babylon.translate("readTableDoneNone", Integer.valueOf(0))));
            }
            long startMS = System.currentTimeMillis();
            OlapLoggers.UX_REQUEST.info((Object)("[UX] table [" + data.getName() + "] read started"));
            int rowCount = UxProcessTableQuery.readTable(queryContext, lock, schema, (IOlapBuilderTabularDataDef)data);
            long endMS = System.currentTimeMillis();
            long elapsedMS = endMS - startMS;
            long rowSec = (int)((double)rowCount * 1000.0 / (double)elapsedMS);
            OlapLoggers.UX_REQUEST.info((Object)("[UX] table [" + data.getName() + "] read completed [" + CdTimeUtils.formatMillis((long)elapsedMS) + "]"));
            return UxReply.actionSuccess(new UxActionStatus(babylon.translate("readTableDone", new Serializable[]{CdStringUtils.formatNice((long)rowCount), CdStringUtils.formatNice((long)rowSec)})));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readTable(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef table) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            CdMutableInt count = new CdMutableInt(0);
            OlapBuilderTableHelper.readTabularData((OlapEngineRequestContext)context.getOlapEngineRequestContext(), (String)context.getBuilderSnapshot(), (OlapBuilderConnectionPool)connectionPool, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderTabularDataDef)table, row -> {
                ++count.value;
                return true;
            });
            int n = count.value;
            return n;
        }
    }
}

