/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.export;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeTask;
import crazydev.iccube.server.request.request.other.IcCubeTableExportCsvServerRequest;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentExReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UxExportTableQuery
extends UxSchemaBuilderQuery {
    @Nullable
    protected final UxBuilderTablePathName tableName;
    @Nullable
    protected final String viewName;

    public UxExportTableQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable UxBuilderTablePathName tableName, @Nullable String viewName) {
        super(meta, requestId, schemaId);
        this.tableName = tableName;
        this.viewName = viewName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.tableName == null && CdStringUtils.isNullOrBlank((String)this.viewName)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.PARAM_MISSING, (Serializable[])new Serializable[]{"tableName|viewName"}));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchemaClone(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataViewDef data;
            if (this.tableName != null) {
                UxBuilderTableReference table = schema.getDataTable(lock, this.tableName);
                if (table != null) {
                    table.table.setDataSource(table.dataSource);
                    data = table.table;
                } else {
                    data = null;
                }
                if (data == null) {
                    return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"table", this.tableName.asErrorInfo()}));
                }
            } else {
                data = schema.getDataViewByName(lock, this.viewName);
                if (data == null) {
                    return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"view", this.viewName}));
                }
            }
            return this.createAttachement(queryContext, lock, schema, (IOlapBuilderTabularDataDef)data);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportTable(UxQueryContext context, OutputStream out, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef table) {
        IcCubeRequestStatusManager statusManager = context.getRequestStatusManager();
        String sessionUUID = context.getSessionContext().getSessionId();
        String userName = context.getUserName();
        OlapTenant userTenant = context.getUserTenant();
        OlapRequestId requestId = context.asServerRequestContext().getRequestId();
        IcCubeTableExportCsvServerRequest request = new IcCubeTableExportCsvServerRequest(requestId, schema.getName(), table.getName());
        SimpleTask task = new SimpleTask(request);
        ArrayList<SimpleTask> tasks = new ArrayList<SimpleTask>();
        tasks.add(task);
        SimpleFuture future = new SimpleFuture();
        statusManager.onRequestReceived(sessionUUID, userName, userTenant, (IcCubeRequest)request, null);
        try {
            statusManager.onRequestProcessingStarted((IcCubeRequest)request);
            statusManager.onRequestTasksGenerated((IcCubeRequest)request, tasks);
            statusManager.onRequestTaskSubmitted((IcCubeTask)task, (Future)future);
            this.doExportTable(context, out, lock, schema, table, future);
        }
        finally {
            statusManager.onRequestTaskDone((IcCubeTask)task);
            statusManager.onRequestProcessingCompleted(sessionUUID, (IcCubeRequest)request, null);
        }
    }

    abstract void doExportTable(UxQueryContext var1, OutputStream var2, UxBuilderSchemaLock var3, UxBuilderSchema var4, IOlapBuilderTabularDataDef var5, SimpleFuture var6);

    @NotNull
    abstract UxAttachmentExReply createAttachement(UxQueryContext var1, UxBuilderSchemaLock var2, UxBuilderSchema var3, IOlapBuilderTabularDataDef var4);

    public static class SimpleTask
    extends IcCubeTask {
        protected SimpleTask(IcCubeRequest request) {
            super(request, "single-task", null);
        }
    }

    public static class SimpleFuture
    implements Future {
        private final Thread runningThread = Thread.currentThread();
        private volatile boolean cancelled = false;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.cancelled) {
                if (mayInterruptIfRunning && this.runningThread != Thread.currentThread()) {
                    this.runningThread.interrupt();
                }
                this.cancelled = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        public Object get() throws InterruptedException, ExecutionException {
            return null;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

