/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.create.discover;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datatable.create.discover.UxDiscoveredTableNames;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDiscoverDataTablesQuery
extends UxSchemaBuilderQuery {
    private final String dataSourceName;
    private final boolean filterSystemTables;
    @Nullable
    private final String filterTables;

    public UxDiscoverDataTablesQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String dataSourceName, boolean filterSystemTables, @Nullable String filterTables) {
        super(meta, requestId, schemaId);
        this.dataSourceName = dataSourceName;
        this.filterSystemTables = filterSystemTables;
        this.filterTables = filterTables;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            OlapBuilderBaseDataSource ds;
            IOlapBuilderDataSource dataSource = schema.getDataSource(lock, this.dataSourceName);
            if (dataSource == null) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_WIZARD_ERROR, (Serializable[])new Serializable[]{"missing data source [" + this.dataSourceName + "]"}));
            }
            List<String> tableNames = new ArrayList<String>();
            if (dataSource instanceof OlapBuilderBaseDataSource && (ds = (OlapBuilderBaseDataSource)dataSource).isDiscoverTablesSupported()) {
                try (IOlapBuilderConnection conn = null;){
                    OlapRuntimeContext rContext = queryContext.asRuntimeContext();
                    conn = dataSource.createConnection(rContext, true);
                    conn.open(rContext);
                    tableNames = ds.discoverAllTablesNames(conn, this.filterSystemTables, this.filterTables);
                }
            }
            tableNames.sort(String::compareToIgnoreCase);
            return UxReply.actionSuccess(new UxDiscoveredTableNames(tableNames, false));
        });
    }
}

