/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.create;

import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateDataTableWizard;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateTypedDataTableWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefValidation;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxValidateDataTableWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;
    private final int activeStep;

    public UxValidateDataTableWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels, int activeStep) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
        this.activeStep = activeStep;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderCreateDataTableWizard wizard = UxWizardDef.setupCreateDataTableWizardFromJson(queryContext, this.props, this.activeStep, this.stepDefs, this.stepModels);
            this.setModelTypesSetupInfoForDataTable(queryContext, lock, schema, true);
            UxBuilderWizardValidation validation = this.validate(queryContext, lock, schema, wizard);
            UxWizardDefValidation validationUI = this.setupWizardValidationUI(queryContext, validation);
            return UxReply.actionSuccess(validationUI);
        });
    }

    private UxBuilderWizardValidation validate(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, UxBuilderCreateDataTableWizard wizard) {
        IOlapBuilderDataSource dataSource = this.setupCreateDataTableWizardDataSourceFromUI(context, lock, schema, wizard);
        if (this.activeStep == 0 && wizard.getTypedWizardStepsOffset() > 0) {
            return this.validateDataSourceName(context, wizard, dataSource);
        }
        return this.validateTypedDataSource(context, wizard, dataSource);
    }

    private UxBuilderWizardValidation validateDataSourceName(UxQueryContext context, UxBuilderCreateDataTableWizard wizard, IOlapBuilderDataSource dataSource) {
        UxBuilderCreateTypedDataTableWizard typedWizard = dataSource.setupCreateDataTableWizard();
        List newSteps = typedWizard.getSteps();
        UxBabylonService babylon = context.getUxBabylonService();
        String useCase = babylon.translateUseCaseCaption(UxBuilderUseCaseName.CreateDataTable.name(), new Serializable[0]);
        String dataSourceName = " : " + dataSource.getName();
        return new UxBuilderWizardValidation(this.activeStep, newSteps, useCase + dataSourceName);
    }

    private UxBuilderWizardValidation validateTypedDataSource(UxQueryContext context, UxBuilderCreateDataTableWizard wizard, IOlapBuilderDataSource dataSource) {
        UxBuilderCreateTypedDataTableWizard typedWizard = dataSource.setupCreateDataTableWizard();
        List typedWizardSteps = wizard.getTypedWizardSteps();
        typedWizard.setSteps(typedWizardSteps);
        UxBuilderWizardValidation validation = typedWizard.validate(context.asRuntimeContext(), this.activeStep - wizard.getTypedWizardStepsOffset());
        return new UxBuilderWizardValidation(this.activeStep, validation.getSteps());
    }
}

