/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.create;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateDataTableWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datatable.create.UxCreateDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.create.UxSaveDataTableWizardQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.create.UxValidateDataTableWizardQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefReplyPayload;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefStep;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardLastStep;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxCreateDataTableQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final String dataSourceName;

    public UxCreateDataTableQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable String dataSourceName) {
        super(meta, requestId, schemaId);
        this.dataSourceName = dataSourceName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource dataSource;
            if (!CdStringUtils.isNullOrBlank((String)this.dataSourceName)) {
                dataSource = schema.getDataSource(lock, this.dataSourceName);
                if (dataSource == null) {
                    throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_WIZARD_ERROR, (Serializable[])new Serializable[]{"missing data source [" + this.dataSourceName + "]"}));
                }
            } else {
                dataSource = schema.getOnlyDataSource(lock);
            }
            if (schema.getDataSourceCount(lock) == 0) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_WIZARD_ERROR, (Serializable[])new Serializable[]{queryContext.getUxBabylonService().translate("createDataTableNoDataSource", new Serializable[0])}));
            }
            this.setModelTypesSetupInfoForDataTable(queryContext, lock, schema, true);
            UxBuilderCreateDataTableWizard wizard = UxBuilderCreateDataTableWizard.create((IOlapBuilderDataSource)dataSource);
            UxWizardDef wizardDef = this.setupWizardDef(queryContext, wizard);
            return UxReply.success(new UxWizardDefReplyPayload(wizardDef));
        });
    }

    private UxWizardDef setupWizardDef(UxQueryContext context, UxBuilderCreateDataTableWizard wizard) {
        UxBabylonService babylon = context.getUxBabylonService();
        String dsName = wizard.getDataSourceName();
        Object useCaseTitle = babylon.translateUseCaseCaption(UxBuilderUseCaseName.CreateDataTable.name(), new Serializable[0]);
        if (CdStringUtils.isNotNullAndNotBlank((String)dsName)) {
            useCaseTitle = (String)useCaseTitle + " ( " + dsName + " )";
        }
        ArrayList<UxWizardDefStep> stepsUI = new ArrayList<UxWizardDefStep>();
        for (UxBuilderWizardStep step : wizard.getSteps()) {
            stepsUI.add(this.setupWizardStepUI(context, step));
        }
        String captionAllDoneC = babylon.translate("wizard.createDataTable.allDoneC", new Serializable[0]);
        String captionAllDoneI = babylon.translate("wizard.createDataTable.allDoneI", new Serializable[0]);
        UxAction create = UxSaveDataTableWizardQueryMeta.createAction(context, this.schemaId);
        UxWizardLastStep lastStep = new UxWizardLastStep(captionAllDoneC, captionAllDoneI, create);
        UxAction validate = UxValidateDataTableWizardQueryMeta.createAction(context, this.schemaId);
        return new UxWizardDef((String)useCaseTitle, wizard.getProps(), stepsUI, lastStep, validate);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (!CdStringUtils.isNullOrBlank((String)this.dataSourceName)) {
            reply.withUseCase(UxCreateDataTableQueryMeta.createUseCaseForDataSource(queryContext, this.schemaId, this.dataSourceName));
        } else {
            reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.CreateDataTable, this.schemaId));
        }
    }
}

