/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.browse;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.executor.common.OlapBuilderTableHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRows;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.UxResultDockType;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTablePage;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTablePageQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableBrowseReply;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeader;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableRow;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxTableBrowseQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxBuilderTablePathName tableName;
    @Nullable
    private final String viewName;
    private boolean convertValues;

    public UxTableBrowseQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderTablePathName tableName, boolean convertValues) {
        super(meta, requestId, schemaId);
        this.tableName = tableName;
        this.viewName = null;
        this.convertValues = convertValues;
    }

    public UxTableBrowseQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName, boolean convertValues) {
        super(meta, requestId, schemaId);
        this.tableName = null;
        this.viewName = viewName;
        this.convertValues = convertValues;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.tableName == null && CdStringUtils.isNullOrBlank((String)this.viewName)) {
            return UxReply.actionSuccess(new UxTableBrowseReply(null, new UxTablePage()));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchemaClone(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderTabularDataDef data = UxTableBrowseQuery.getTabularData(lock, schema, this.tableName, this.viewName);
            if (data == null) {
                return UxTableBrowseQuery.replyTabularDataNotFound(queryContext, this.tableName, this.viewName);
            }
            return UxTableBrowseQuery.browse(queryContext, lock, schema, this.schemaId, data, this.convertValues);
        });
    }

    public static UxReply browse(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, UxSchemaId schemaId, IOlapBuilderTabularDataDef data, boolean convertValues) {
        int pageSize = 1000;
        boolean pageNumber = true;
        UxTablePage page = UxTableBrowseQuery.browseTablePage(queryContext, lock, schema, data, convertValues, 1000, 1);
        UxAction nextPage = UxTablePageQueryMeta.createAction(queryContext, schemaId, data.getId(), convertValues, 1000, 1);
        UxResultDockName dockName = new UxResultDockName(UxResultDockType.TABLE_BROWSE, data.getId(), data.getName());
        return UxReply.actionSuccess((UxActionResult)new UxTableBrowseReply(nextPage, page), dockName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UxTablePage browseTablePage(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef table, boolean convertValues, int pageSize, int pageNumber) {
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            OlapBuilderBaseDataTableRows info = OlapBuilderTableHelper.browseTabularData((OlapEngineRequestContext)context.getOlapEngineRequestContext(), (String)context.getBuilderSnapshot(), (OlapBuilderConnectionPool)connectionPool, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderTabularDataDef)table, (boolean)convertValues, (int)pageSize, (int)pageNumber);
            ArrayList<UxTableHeader> headers = new ArrayList<UxTableHeader>();
            for (Object column : info.getColumns()) {
                headers.add(new UxTableHeader(context.getUxBabylonService(), (IOlapBuilderDataColumnDef)column));
            }
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            for (OlapBuilderBaseDataTableRow row : info.getRows()) {
                ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
                for (String value : row.values()) {
                    cells.add(new UxTableCell(value));
                }
                rows.add(new UxTableRow(cells));
            }
            UxTable data = UxTable.create(new UxTableHeaders(headers.toArray(new UxTableHeader[headers.size()])), rows);
            UxTablePage uxTablePage = new UxTablePage(pageSize, pageNumber, data);
            return uxTablePage;
        }
    }
}

