/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.analyse;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder2.cruncher.UxCruncher;
import crazydev.iccube.builder2.cruncher.UxCruncherConfiguration;
import crazydev.iccube.builder2.cruncher.UxCruncherFlatReport;
import crazydev.iccube.builder2.cruncher.UxCruncherHierarchicalReport;
import crazydev.iccube.builder2.cruncher.UxCruncherResult;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.UxResultDockType;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeader;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UxTableAnalyseQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxBuilderTablePathName tableName;
    @Nullable
    private final String viewName;
    private final UxCruncherConfiguration configuration;

    public UxTableAnalyseQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderTablePathName tableName, UxCruncherConfiguration configuration) {
        super(meta, requestId, schemaId);
        this.tableName = tableName;
        this.viewName = null;
        this.configuration = configuration;
    }

    public UxTableAnalyseQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName, UxCruncherConfiguration configuration) {
        super(meta, requestId, schemaId);
        this.tableName = null;
        this.viewName = viewName;
        this.configuration = configuration;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.tableName == null && CdStringUtils.isNullOrBlank((String)this.viewName)) {
            return UxReply.success(new UxTableReplyPayload(UxTable.empty()));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchemaClone(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderTabularDataDef data = UxTableAnalyseQuery.getTabularData(lock, schema, this.tableName, this.viewName);
            if (data == null) {
                return UxTableAnalyseQuery.replyTabularDataNotFound(queryContext, this.tableName, this.viewName);
            }
            return UxTableAnalyseQuery.analyse(queryContext, lock, schema, data, this.configuration);
        });
    }

    public static UxReply analyse(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef data, UxCruncherConfiguration configuration) {
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        UxTableHeader header = new UxTableHeader("First", "What");
        UxTableHeader header2 = new UxTableHeader("Second", "Message");
        UxTableHeaders headers = new UxTableHeaders(header, header2);
        UxCruncherResult result = UxCruncher.crunchTable((OlapEngineRequestContext)queryContext.getOlapEngineRequestContext(), (String)queryContext.getBuilderSnapshot(), (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderTabularDataDef)data, (UxCruncherConfiguration)configuration);
        if (result == null) {
            rows.add(new UxTableRow(Arrays.asList(new UxTableCell("Row Count"), new UxTableCell(Integer.toString(0)))));
        } else {
            UxCruncherHierarchicalReport relations;
            boolean addSpace = false;
            UxCruncherFlatReport distincts = result.distincts;
            if (distincts != null) {
                rows.add(new UxTableRow(Arrays.asList(new UxTableCell("Distinct Values"), new UxTableCell(distincts.getRowCount() + " rows"))));
                UxTableAnalyseQuery.addCellContentAnalysis(rows, distincts);
                addSpace = true;
            }
            if ((relations = result.relations) != null) {
                UxTableAnalyseQuery.addHeader(rows, "Alias - One to One Relations (e.g. a key/id with a name) ", addSpace);
                UxTableAnalyseQuery.addOneToOneRelations(rows, relations);
                addSpace = true;
                UxTableAnalyseQuery.addHeader(rows, "Potential Parent Child Relations (e.g. country and city, year and month)", addSpace);
                UxTableAnalyseQuery.addParentChildRelations(rows, relations);
            }
        }
        UxTable resTable = UxTable.create(headers, rows);
        UxResultDockName dockName = new UxResultDockName(UxResultDockType.TABLE_ANALYSE, data.getId(), data.getName());
        return UxReply.actionSuccess((UxActionResult)resTable, dockName);
    }

    public static void addHeader(List<UxTableRow> rows, String title, boolean addSpace) {
        if (addSpace) {
            rows.add(new UxTableRow(Arrays.asList(new UxTableCell(""), new UxTableCell(""))));
        }
        rows.add(new UxTableRow(Arrays.asList(new UxTableCell(title), new UxTableCell(""))));
    }

    public static void addCellContentAnalysis(List<UxTableRow> rows, UxCruncherFlatReport flatReport) {
        Map columnsWithTop15Values = flatReport.getTopValues(15, true);
        ArrayList sortedCols = new ArrayList(columnsWithTop15Values.keySet());
        sortedCols.sort(Comparator.comparingInt(arg_0 -> ((UxCruncherFlatReport)flatReport).getExistingCountUnique(arg_0)));
        sortedCols.forEach(col -> {
            Comparable[] values = (Comparable[])columnsWithTop15Values.get(col);
            int nullValuesCount = flatReport.getExistingCount(col, null);
            int emptyValuesCount = flatReport.getExistingCount(col, (Comparable)((Object)""));
            Object nullMessage = nullValuesCount == 0 ? "" : "null (" + nullValuesCount + "), ";
            nullMessage = (String)nullMessage + (String)(emptyValuesCount == 0 ? "" : "'' (" + emptyValuesCount + "), ");
            StringBuilder value = new StringBuilder(flatReport.getExistingCountUnique(col) + " distinct values : " + (String)nullMessage);
            for (int i = 0; i < values.length; ++i) {
                Comparable val = values[i];
                int count = flatReport.getExistingCount(col, val);
                value.append(i == 0 ? "" : ", ").append(val).append(" (").append(count).append(")");
            }
            rows.add(new UxTableRow(Arrays.asList(new UxTableCell(col.getName()), new UxTableCell(value))));
        });
    }

    public static void addParentChildRelations(List<UxTableRow> rows, UxCruncherHierarchicalReport hierReport) {
        if (hierReport.getParentChild().isEmpty()) {
            rows.add(new UxTableRow(Arrays.asList(new UxTableCell("No ParentChild"), new UxTableCell(""))));
        } else {
            hierReport.getParentChild().forEach(parentChild -> rows.add(new UxTableRow(Arrays.asList(new UxTableCell(((IOlapBuilderDataColumnDef)parentChild.fst).getName()), new UxTableCell(((IOlapBuilderDataColumnDef)parentChild.snd).getName())))));
        }
    }

    public static void addOneToOneRelations(List<UxTableRow> rows, UxCruncherHierarchicalReport hierReport) {
        if (hierReport.getAliasColumn().isEmpty()) {
            rows.add(new UxTableRow(Arrays.asList(new UxTableCell("No Alias"), new UxTableCell(""))));
        } else {
            hierReport.getAliasColumn().forEach(aliasCols -> rows.add(new UxTableRow(Arrays.asList(new UxTableCell("Alias"), new UxTableCell(aliasCols.toString())))));
        }
    }
}

