/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.property.CdProperty;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.model.UxModelPropertyAccessorListener;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UxTablePropertyAccessorListener
implements UxModelPropertyAccessorListener {
    private final IOlapBuilderDataTableDef table;

    public UxTablePropertyAccessorListener() {
        this(null);
    }

    public UxTablePropertyAccessorListener(@Nullable IOlapBuilderDataTableDef table) {
        this.table = table;
    }

    @Override
    @Nullable
    public Object afterGetFromServer(CdProperty property, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (property == OlapBuilderBaseDataTable.ALL_PERSISTENT_COLUMNS || property == OlapBuilderBaseDataView.COLUMNS) {
            ArrayList sortedColumns = new ArrayList();
            sortedColumns.addAll((List)value);
            sortedColumns.sort(IOlapBuilderDataColumnDef.SORTED_COLUMNS);
            return sortedColumns;
        }
        return value;
    }

    @Override
    @Nullable
    public Object beforeSetToServer(CdProperty property, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (property == OlapBuilderBaseDataTable.ALL_PERSISTENT_COLUMNS || property == OlapBuilderBaseDataView.COLUMNS) {
            if (this.table == null) {
                throw new RuntimeException("internal error: missing server side table");
            }
            Map columnPositions = this.table.createAllColumnsPositions();
            List sortedColumnsUI = (List)value;
            IOlapBuilderDataColumnDef[] fixedColumnsUI = new IOlapBuilderDataColumnDef[sortedColumnsUI.size()];
            for (IOlapBuilderDataColumnDef sortedColumnUI : sortedColumnsUI) {
                Integer pos = (Integer)columnPositions.get(sortedColumnUI.getName());
                if (pos == null) {
                    throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DT_COLUMNS_MISMATCH, (Serializable[])new Serializable[0]));
                }
                fixedColumnsUI[pos.intValue()] = sortedColumnUI;
            }
            return new ArrayList<IOlapBuilderDataColumnDef>(Arrays.asList(fixedColumnsUI));
        }
        return value;
    }
}

