/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.UxDuplicateTableQuery;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDuplicateTableQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxDuplicateTableQueryMeta DuplicateTable = new UxDuplicateTableQueryMeta();

    protected UxDuplicateTableQueryMeta() {
        super(UxConsoleConstants.QueryName.DuplicateTable);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        String info = params.getInfoParameter();
        String dataSourceName = params.getStringParameter("dataSourceName");
        String tableName = params.getStringParameter("tableName");
        UxBuilderTablePathName tableUniqueName = CdStringUtils.isNotNullAndNotBlank((String)dataSourceName) && CdStringUtils.isNotNullAndNotBlank((String)tableName) ? UxBuilderTablePathName.create(dataSourceName, tableName) : null;
        String viewName = params.getStringParameter("viewName");
        if (tableUniqueName == null && CdStringUtils.isNullOrBlank((String)viewName)) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{"dataSourceName|tableName|viewName"});
        }
        if (tableUniqueName != null) {
            return new UxDuplicateTableQuery((UxQueryMeta)this, params.getRequestId(), info, schemaId, tableUniqueName);
        }
        return new UxDuplicateTableQuery((UxQueryMeta)this, params.getRequestId(), info, schemaId, viewName);
    }

    @Nullable
    public static UxAction createActionForTable(UxQueryContext context, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, DuplicateTable, schemaId).withParams(new UxField(babylon, "dataSourceName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(tableName.getDataSourceName())), new UxField(babylon, "tableName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(tableName.getTableName()))).withPlacement(2).build();
    }

    @Nullable
    public static UxAction createActionForView(UxQueryContext context, UxSchemaId schemaId, String viewName) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, DuplicateTable, schemaId).withParams(new UxField(babylon, "viewName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(viewName))).withPlacement(2).build();
    }
}

