/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTablePage;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTableBrowseReply;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UxDuplicateTableQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxBuilderTablePathName tableName;
    @Nullable
    private final String viewName;
    @Nullable
    private final String info;

    public UxDuplicateTableQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String info, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        super(meta, requestId, schemaId);
        this.info = info;
        this.tableName = tableName;
        this.viewName = null;
    }

    public UxDuplicateTableQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String info, UxSchemaId schemaId, String viewName) {
        super(meta, requestId, schemaId);
        this.info = info;
        this.tableName = null;
        this.viewName = viewName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.tableName == null && CdStringUtils.isNullOrBlank((String)this.viewName)) {
            return UxReply.actionSuccess(new UxTableBrowseReply(null, new UxTablePage()));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderTabularDataDef data = UxDuplicateTableQuery.getTabularData(lock, schema, this.tableName, this.viewName);
            if (data == null) {
                return UxDuplicateTableQuery.replyTabularDataNotFound(queryContext, this.tableName, this.viewName);
            }
            if (data instanceof IOlapBuilderDataViewDef) {
                return this.duplicateView(queryContext, service, lock, schema, (IOlapBuilderDataViewDef)data);
            }
            return this.duplicateTable(queryContext, service, lock, schema, (IOlapBuilderDataTableDef)data);
        });
    }

    @NotNull
    private UxReply duplicateTable(UxQueryContext queryContext, UxBuilderSchemaService service, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataTableDef data) {
        try {
            IOlapBuilderDataTableDef tableDef = data;
            UxBuilderTablePathName newName = this.tableName;
            while (schema.getDataTable(lock, newName = newName.duplicate()) != null) {
            }
            IOlapBuilderDataTableDef duplicatedTable = UxBuilderSchemaService.duplicateDefinition(queryContext.getOlapEngineComponent().getBuilderMetaInformationRepository(), tableDef);
            duplicatedTable.resetId();
            duplicatedTable.setName(newName.getTableName());
            schema.insertDataTable(lock, newName.getDataSourceName(), duplicatedTable);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "duplicate table: " + this.tableName.asString());
            UxActionContinuation continuation = null;
            if (!"table".equals(this.info)) {
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDataTableQueryMeta.createUseCase(queryContext, this.schemaId, null, duplicatedTable.getId(), newName));
            }
            return UxReply.actionSuccess(continuation);
        }
        catch (JAXBException | IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] duplicate table [" + this.tableName.asString() + "] error"), ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_TABLE_DUPLICATE, (Serializable[])new Serializable[]{this.tableName.asString(), ex.getMessage()}));
        }
    }

    @NotNull
    private UxReply duplicateView(UxQueryContext queryContext, UxBuilderSchemaService service, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataViewDef data) {
        try {
            IOlapBuilderDataViewDef viewDef = data;
            String newName = this.viewName;
            while (schema.getDataViewByName(lock, newName = IOlapBuilderNamedDef.copyName((String)newName)) != null) {
            }
            IOlapBuilderDataViewDef duplicatedView = UxBuilderSchemaService.duplicateDefinition(queryContext.getOlapEngineComponent().getBuilderMetaInformationRepository(), viewDef);
            duplicatedView.resetId();
            duplicatedView.setName(newName);
            schema.insertDataView(lock, duplicatedView);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "duplicate transformation: " + this.viewName);
            UxActionContinuation continuation = null;
            if (!"table".equals(this.info)) {
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDataViewQueryMeta.createUseCase(queryContext, this.schemaId, null, duplicatedView.getId(), newName, duplicatedView.getHelpUrl()));
            }
            return UxReply.actionSuccess(continuation);
        }
        catch (JAXBException | IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] duplicate view [" + this.viewName + "] error"), ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_VIEW_DUPLICATE, (Serializable[])new Serializable[]{this.viewName, ex.getMessage()}));
        }
    }
}

