/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.iccube.builder.datasource.facts.OlapBuilderBaseFacts;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByKind;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderBridge;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaUsageHelper;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.model.UxBuilderTabularDataUsage;
import crazydev.iccube.ux.builder.queries.colors.UxSchemaColorsQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTablesQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.queries.localization.UxSchemaLocalizationQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxDataTablesQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxDataTablesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            Object table2;
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableHeaders header = UxTableHeaders.create(babylon, "name", "description", "dataSourceName", "usedByEx");
            UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<UxBuilderTableReference>("name", babylon.translate("filterDataTableName", new Serializable[0]), UxBuilderTableReference::getTableName), new UxFilterMeta<UxBuilderTableReference>("description", babylon.translate("filterDataTableDescription", new Serializable[0]), UxBuilderTableReference::getTableDescription), new UxFilterMeta<UxBuilderTableReference>("dataSourceName", babylon.translate("filterDataSourceName", new Serializable[0]), UxBuilderTableReference::getDataSourceName));
            UxTableRowSearcher<UxBuilderTableReference> searcher = new UxTableRowSearcher<UxBuilderTableReference>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean isAccepting(UxBuilderTableReference row, String searchText) {
                    return this.isContaining(searchText, row.getDataSourceName(), row.getTableName());
                }
            };
            ArrayList tables_ = new ArrayList();
            schema.forEachTable(lock, tables_::add);
            tables_.sort((o1, o2) -> {
                int cmp = o1.getTableName().compareToIgnoreCase(o2.getTableName());
                if (cmp == 0) {
                    return o1.getDataSourceName().compareToIgnoreCase(o2.getDataSourceName());
                }
                return cmp;
            });
            List<UxBuilderTableReference> tables = this.filter(this.tableOptions, searcher, filterMetas, tables_);
            UxBuilderTabularDataUsage usages = UxBuilderSchemaUsageHelper.getUsageAllTables(lock, schema, tables);
            int totalRowCount = tables.size();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            for (Object table2 : tables) {
                rows.add(UxDataTablesQuery.createRow(queryContext, this.schemaId, schema, usages, table2));
            }
            List<UxAction> multiSelectionActions = UxDataTablesQueryMeta.createMultiSelectionActions(queryContext, this.schemaId);
            table2 = UxTable.create(options, header, rows, multiSelectionActions);
            UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
            return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, (UxTable)((Object)((Object)table2))));
        });
    }

    private static UxTableRow createRow(UxQueryContext context, UxSchemaId schemaId, UxBuilderSchema schema, UxBuilderTabularDataUsage usages, UxBuilderTableReference table) {
        List<IOlapBuilderUsedByDef> usedBy = !usages.isNotUsed(table) ? usages.getUsedBy(table) : null;
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(table.getTableName()));
        cells.add(new UxTableCell(table.getTableDescription()));
        cells.add(new UxTableCell(table.getDataSourceName()));
        cells.add(new UxTableCell(UxDataTablesQuery.createUsedByCaption0(context, usedBy)));
        UxTableRow row = new UxTableRow(cells);
        String schemaName = schema != null ? schema.getName() : null;
        row.setUseCase(UxDataTableQueryMeta.createUseCase(context, schemaId, schemaName, table.getTableId(), table.uniqueName()));
        row.getCells().get(2).setUseCase(UxDataSourceQueryMeta.createUseCase(context, schemaId, table.getDataSourceName(), null, false));
        row.getCells().get(3).setUseCase(UxDataTablesQuery.createUsedByUseCase0(context, schemaId, usedBy));
        return row;
    }

    public static String createUsedByCaption0(UxQueryContext context, @Nullable List<IOlapBuilderUsedByDef> usedBy) {
        String name;
        if (usedBy == null || usedBy.isEmpty()) {
            return "";
        }
        UxBabylonService babylon = context.getUxBabylonService();
        IOlapBuilderUsedByDef first = usedBy.get(0);
        IOlapBuilderUsedByKind type = first.getUsedByTag();
        String string = name = type == IOlapBuilderUsedByKind.colors || type == IOlapBuilderUsedByKind.localization ? babylon.translate(type.name(), new Serializable[0]) : babylon.translate(type.name(), new Serializable[0]) + " : " + first.getName();
        if (usedBy.size() > 1) {
            return babylon.translate("usedByCaption", new Serializable[]{name, Integer.valueOf(usedBy.size() - 1)});
        }
        return name;
    }

    @Nullable
    public static UxUseCase createUsedByUseCase0(UxQueryContext context, UxSchemaId schemaId, @Nullable List<IOlapBuilderUsedByDef> usage) {
        if (usage == null || usage.isEmpty()) {
            return null;
        }
        UxUseCase uc = UxDataTablesQuery.createUsedByUseCase(context, schemaId, usage.get(0));
        if (uc != null && usage != null && usage.size() > 1) {
            UxBabylonService babylon = context.getUxBabylonService();
            StringBuilder tooltip = new StringBuilder();
            for (int ii = 0; ii < usage.size(); ++ii) {
                IOlapBuilderUsedByDef usedBy = usage.get(ii);
                IOlapBuilderUsedByKind type = usedBy.getUsedByTag();
                String name = usedBy.getName();
                if (ii > 0) {
                    tooltip.append(",\n");
                }
                tooltip.append(babylon.translate("usedByCaption", new Serializable[]{babylon.translate(type.name(), new Serializable[0]), name}));
            }
            uc.setCaptionTooltip(tooltip.toString());
        }
        return uc;
    }

    @Nullable
    public static UxUseCase createUsedByUseCase(UxQueryContext context, UxSchemaId schemaId, IOlapBuilderUsedByDef useBy) {
        if (useBy instanceof IOlapBuilderLocalizationDef) {
            return new UxUseCaseBuilder(context, UxSchemaLocalizationQueryMeta.SchemaLocalization, schemaId).withId(UxBuilderUseCaseName.SchemaLocalization).build(false);
        }
        if (useBy instanceof IOlapBuilderColorsDef) {
            return new UxUseCaseBuilder(context, UxSchemaColorsQueryMeta.SchemaColors, schemaId).withId(UxBuilderUseCaseName.SchemaColors).build(false);
        }
        if (useBy instanceof IOlapBuilderDimensionDef) {
            IOlapBuilderDimensionDef dim = (IOlapBuilderDimensionDef)useBy;
            return UxDimensionQueryMeta.createUseCase(context, UxActionSetup.NONE, schemaId, null, UxBuilderDimensionUniqueName.create(dim), false);
        }
        if (useBy instanceof IOlapBuilderDataViewDef) {
            IOlapBuilderDataViewDef view = (IOlapBuilderDataViewDef)useBy;
            return UxDataViewQueryMeta.createUseCase(context, schemaId, null, null, view.getName(), null);
        }
        if (useBy instanceof OlapBuilderBaseFacts) {
            OlapBuilderBaseFacts facts = (OlapBuilderBaseFacts)useBy;
            return UxMeasureGroupQueryMeta.createUseCase(context, UxActionSetup.NONE, schemaId, null, UxBuilderMeasureGroupUniqueName.create(facts.getCube(), (IOlapBuilderBaseFactsDef)facts));
        }
        if (useBy instanceof UxBuilderBridge) {
            UxBuilderBridge bridge = (UxBuilderBridge)useBy;
            return UxMeasureGroupQueryMeta.createUseCase(context, UxActionSetup.NONE, schemaId, null, UxBuilderMeasureGroupUniqueName.create(bridge.getCube(), bridge.getFacts()));
        }
        return null;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.DataTables, this.schemaId));
    }
}

