/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.switch_;

import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.ux.admin.queries.completion.UxCompleteQueryMeta;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionType;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datasource.switch_.UxSwitchDataSourceQuery;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class UxSwitchDataSourceQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxSwitchDataSourceQueryMeta SwitchDataSource = new UxSwitchDataSourceQueryMeta();

    protected UxSwitchDataSourceQueryMeta() {
        super(UxConsoleConstants.QueryName.SwitchDataSource);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        String fromDataSourceId = params.getExistingStringParameter("fromDataSource");
        String toDataSourceId = params.getExistingStringParameter("toDataSource");
        return new UxSwitchDataSourceQuery(this, params.getRequestId(), schemaId, fromDataSourceId, toDataSourceId);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, UxSchemaId schemaId, String dataSourceName) {
        UxBabylonService babylon = context.getUxBabylonService();
        MutableBoolean hasAction = new MutableBoolean();
        try {
            UxSwitchDataSourceQueryMeta.addMatchingDS(context.getPersistentSchemaService(), schemaId, dataSourceName, ds -> hasAction.setValue(true));
        }
        catch (UxBuilderSchemaServiceException e) {
            return null;
        }
        if (!hasAction.booleanValue()) {
            return null;
        }
        return new UxActionBuilder(context, SwitchDataSource, schemaId).withParams(new UxField(babylon, "fromDataSource", new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(dataSourceName)), new UxField(babylon, "toDataSource", new UxFieldMeta(UxFieldTypes.STRING, UxCompleteQueryMeta.createAction(context, UxCompletionType.dataTypedSourceNames, schemaId.schemaName, dataSourceName), true, true, false, true), new UxFieldValue())).build();
    }

    public static void addMatchingDS(UxBuilderSchemaService service, UxSchemaId schemaId, String dataSourceName, Consumer<IOlapBuilderDataSource> onMatchingDS) throws UxBuilderSchemaServiceException {
        service.readSchema(schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource ds = dataSourceName == null ? null : schema.getExistingDataSource(lock, dataSourceName);
            List<IOlapBuilderDataSource> names = schema.getDataSources(lock);
            for (IOlapBuilderDataSource name : names) {
                if (ds == null || name == ds || name.getClass() != ds.getClass()) continue;
                onMatchingDS.accept(name);
            }
            return true;
        });
    }
}

