/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.switch_;

import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxSwitchDataSourceQuery
extends UxSchemaBuilderQuery {
    private final String fromDataSource;
    private final String toDataSource;

    public UxSwitchDataSourceQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String fromDataSource, String toDataSource) {
        super(meta, requestId, schemaId);
        this.fromDataSource = fromDataSource;
        this.toDataSource = toDataSource;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource fromDS = schema.getExistingDataSource(lock, this.fromDataSource);
            IOlapBuilderDataSource toDS = schema.getExistingDataSource(lock, this.toDataSource);
            schema.switchDataSource(lock, fromDS, toDS);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "switch datasource: " + this.fromDataSource + " to: " + this.toDataSource);
            return UxReply.actionSuccess();
        });
    }
}

