/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc;

import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.ux.builder.queries.datasource.UxJdbcDataSourceAdvPropsQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.UxBuilderAbstractDataSourceModelType;
import crazydev.iccube.ux.common.field.UxFieldEditorMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.model.UxModelTypeSetupInfo;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.processor.UxBabylonService;
import org.jetbrains.annotations.Nullable;

public abstract class UxBuilderJdbcDataSourceModelType<DS extends OlapBuilderJdbcDataSource>
extends UxBuilderAbstractDataSourceModelType<DS> {
    public static final String GROUP_JDBC_DRIVER = "group.dataSourceJdbcDriver";
    public static final String GROUP_JDBC_SERVER = "group.dataSourceJdbcServer";
    public static final String GROUP_JDBC_USER = "group.dataSourceJdbcUser";
    public static final String GROUP_PLAYGROUND = "group.dataSourcePlayground";
    public static final String SHOW_DRIVER_TYPE_RO = "SHOW_DRIVER_TYPE_RO";

    protected UxBuilderJdbcDataSourceModelType(String persistentId, Class<DS> serverModelClass) {
        super(persistentId, serverModelClass);
    }

    @Override
    public boolean isVisibleInReporting() {
        return true;
    }

    @Override
    protected void doSetupProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable DS model) {
        super.doSetupProperties(context, modelOwner, model);
        UxBabylonService babylon = context.getUxBabylonService();
        this.addSetupPropertiesPhaseII(context, babylon);
        this.addProperty(context, "group.dataSourceAdvanced", OlapBuilderJdbcDataSource.DISABLE_READ_ONLY_MODE, UxFieldTypes.BOOLEAN, true, false, true);
        this.addProperty(context, "group.dataSourceAdvanced", OlapBuilderJdbcDataSource.DISABLE_AUTO_COMMIT_FALSE, UxFieldTypes.BOOLEAN, true, false, true);
        this.addProperty(context, "group.dataSourceAdvanced", OlapBuilderJdbcDataSource.STRING_CONVERTER_LOCALE, UxFieldTypes.LOCALE(babylon), true, false, false);
        this.addProperty(context, "group.dataSourceAdvanced", OlapBuilderJdbcDataSource.DATE_FORMAT, UxFieldTypes.STRING, true, false, false);
        this.addProperty(context, GROUP_PLAYGROUND, OlapBuilderJdbcDataSource.PLAYGROUND, UxFieldTypes.SQL, true, false, false);
        OlapBuilderDriverType driver = model != null ? model.getDriverType() : null;
        String url = model != null && driver == OlapBuilderDriverType.SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL ? model.getDbNameEx() : null;
        this.addProperty(context, "group.dataSourceAdvanced", OlapBuilderJdbcDataSource.URL_PARAMS, OlapBuilderJdbcDataSource.DB_NAME, UxFieldTypes.TEXT, UxFieldEditorMeta.createForPreview(5), UxJdbcDataSourceAdvPropsQueryMeta.createAction(context, driver, url), null, null, true, true, false, false, null);
    }

    protected void addSetupPropertiesPhaseII(UxQueryContext context, UxBabylonService babylon) {
        this.addProperty(context, OlapBuilderJdbcDataSource.DRIVER_TYPE, UxFieldTypes.ENUM(babylon, OlapBuilderDriverType.class), false, true, true);
        this.addProperty(context, GROUP_JDBC_SERVER, OlapBuilderJdbcDataSource.SERVER_NAME, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, GROUP_JDBC_SERVER, OlapBuilderJdbcDataSource.PORT_NUMBER, UxFieldTypes.STRING, true, false, false);
        this.addProperty(context, GROUP_JDBC_SERVER, OlapBuilderJdbcDataSource.DB_NAME, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, this.useSchema() ? GROUP_JDBC_SERVER : "group.dataSourceAdvanced", OlapBuilderJdbcDataSource.SCHEMA_NAME, UxFieldTypes.STRING, true, false, false);
        this.addProperty(context, GROUP_JDBC_SERVER, OlapBuilderJdbcDataSource.USER, UxFieldTypes.STRING, true, false, true);
        this.addProperty(context, GROUP_JDBC_SERVER, OlapBuilderJdbcDataSource.PASSWORD, UxFieldTypes.PASSWORD, true, false, false);
    }

    protected boolean useSchema() {
        return false;
    }

    @Override
    protected void doSetupNameExProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable DS model) {
        boolean showDriverTypeRO;
        UxBabylonService babylon = context.getUxBabylonService();
        UxModelTypeSetupInfo setup = context.getModelTypeSetupInfo();
        boolean bl = showDriverTypeRO = setup != null && setup.is(SHOW_DRIVER_TYPE_RO);
        if (showDriverTypeRO) {
            this.addProperty(context, "group.dataSourceAdvanced", OlapBuilderJdbcDataSource.DB_TYPE, UxFieldTypes.ENUM(babylon, OlapBuilderDriverType.class), true, true, true);
        }
    }
}

