/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.modeltypes;

import crazydev.iccube.builder.ux.meta.UxBuilderMetaInfo;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeForm;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroup;
import crazydev.iccube.builder.ux.meta.datasource.UxImage;
import crazydev.iccube.ux.builder.queries.image.UxImageQueryMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxHelpText;
import crazydev.iccube.ux.common.model.UxModelType;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.type.UxEnumValue;
import crazydev.iccube.ux.common.type.UxEnumValueGroup;
import crazydev.iccube.ux.common.type.UxImageRef;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.version.OlapVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBuilderDataSourceTypeFormModelType
extends UxModelType<UxBuilderDataSourceTypeForm> {
    protected UxBuilderDataSourceTypeFormModelType() {
        super("dataSourceTypeForm", UxBuilderDataSourceTypeForm.class);
    }

    @Override
    protected void doSetupProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable UxBuilderDataSourceTypeForm model) {
        List<UxEnumValueGroup> groups = this.setupGroups(context);
        this.addProperty(context, UxBuilderDataSourceTypeForm.TYPE, UxFieldTypes.GROUPED_ENUMERABLE(groups), true, false, true);
    }

    private UxEnumValue setupType(UxQueryContext context, UxBuilderDataSourceType type) {
        UxImageRef imageRef;
        UxBabylonService babylon = context.getUxBabylonService();
        String id = type.getId();
        String caption = babylon.translate(id, new Serializable[0]);
        UxHelpText description = babylon.translateModelPropertyDescription(id);
        UxImage image = type.getImage();
        if (image != null) {
            String clazz = image.getClazz().getName();
            String resource = image.getResource();
            String revision = OlapVersion.get().asString();
            UxUrl imageURL = UxImageQueryMeta.Image.createQueryUrl(clazz, resource, revision);
            imageRef = new UxImageRef(imageURL.toUrl());
        } else {
            imageRef = null;
        }
        return new UxEnumValue(id, caption, description, imageRef);
    }

    private UxEnumValueGroup setupGroup(UxQueryContext context, UxBuilderDataSourceTypeGroup group) {
        UxBabylonService babylon = context.getUxBabylonService();
        String id = group.getId().name();
        String caption = babylon.translate(id, new Serializable[0]);
        String description = babylon.translate(id + ".description", new Serializable[0]);
        ArrayList<UxEnumValue> uiTypes = new ArrayList<UxEnumValue>();
        for (UxBuilderDataSourceType type : group.getTypes()) {
            uiTypes.add(this.setupType(context, type));
        }
        uiTypes.sort((o1, o2) -> o1.getCaption().compareToIgnoreCase(o2.getCaption()));
        return new UxEnumValueGroup(id, caption, description, true, uiTypes);
    }

    private List<UxEnumValueGroup> setupGroups(UxQueryContext context) {
        UxBuilderMetaInfo meta = context.getBuilderMetaInfo();
        ArrayList<UxEnumValueGroup> uiGroups = new ArrayList<UxEnumValueGroup>();
        for (UxBuilderDataSourceTypeGroup group : meta.getDataSourceTypeGroups()) {
            uiGroups.add(this.setupGroup(context, group));
        }
        return uiGroups;
    }
}

