/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.create;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefValidation;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxValidateDataSourceWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;
    private final int activeStep;

    public UxValidateDataSourceWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels, int activeStep) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
        this.activeStep = activeStep;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderCreateDataSourceWizard wizard = UxWizardDef.setupCreateDataSourceWizardFromJson(queryContext, this.props, this.activeStep, this.stepDefs, this.stepModels);
            UxBuilderWizardValidation validation = this.validate(queryContext, wizard);
            UxWizardDefValidation validationUI = this.setupWizardValidationUI(queryContext, validation);
            return UxReply.actionSuccess(validationUI);
        });
    }

    private UxBuilderWizardValidation validate(UxQueryContext context, UxBuilderCreateDataSourceWizard wizard) {
        UxBuilderDataSourceType dsType = this.setupCreateDataSourceWizardTypeFromUI(context, wizard);
        if (this.activeStep == 0) {
            return this.validateDataSourceType(context, wizard, dsType);
        }
        return this.validateTypedDataSource(context, wizard, dsType);
    }

    private UxBuilderWizardValidation validateDataSourceType(UxQueryContext context, UxBuilderCreateDataSourceWizard wizard, UxBuilderDataSourceType dsType) {
        UxBuilderCreateTypedDataSourceWizard typedWizard = dsType.createTypedWizard();
        List newSteps = typedWizard.getSteps();
        UxBabylonService babylon = context.getUxBabylonService();
        String id = dsType.getId();
        String caption = babylon.translate(id, new Serializable[0]);
        String useCase = babylon.translateUseCaseCaption(UxBuilderUseCaseName.CreateDataSource.name(), new Serializable[0]);
        String type = CdStringUtils.isNotNullAndNotBlank((String)caption) ? " : " + caption : null;
        return new UxBuilderWizardValidation(this.activeStep, newSteps, useCase + type);
    }

    private UxBuilderWizardValidation validateTypedDataSource(UxQueryContext context, UxBuilderCreateDataSourceWizard wizard, UxBuilderDataSourceType dsType) {
        UxBuilderCreateTypedDataSourceWizard typedWizard = dsType.createTypedWizard();
        List typedWizardSteps = wizard.getTypedWizardSteps();
        typedWizard.setSteps(typedWizardSteps);
        UxBuilderWizardValidation validation = typedWizard.validate(context.asRuntimeContext(), this.activeStep - wizard.getTypedWizardStepsOffset());
        return new UxBuilderWizardValidation(this.activeStep, validation.getSteps());
    }
}

