/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveDataSourceQuery
extends UxSchemaBuilderQuery {
    private final String dataSourceName;
    private final UxModel model;

    public UxSaveDataSourceQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String dataSourceName, UxModel model) {
        super(meta, requestId, schemaId);
        this.dataSourceName = dataSourceName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (!this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderDataSource dataSource = (IOlapBuilderDataSource)converter.convertToServerModel(queryContext, this.model);
            if (!this.dataSourceName.equals(dataSource.getName())) {
                IOlapBuilderDataSource existingDataSource = schema.renameDataSource(lock, this.dataSourceName, dataSource.getName());
                converter.update(existingDataSource, dataSource);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDataSourceQueryMeta.createUseCase(queryContext, this.schemaId, dataSource.getName(), null));
                operation = "rename/edit datasource: " + this.dataSourceName + " into: " + dataSource.getName();
            } else {
                IOlapBuilderDataSource existingDataSource = schema.getExistingDataSource(lock, dataSource.getName());
                converter.update(existingDataSource, dataSource);
                continuation = null;
                operation = "edit datasource: " + dataSource.getName();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

