/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxDataSourcesRefresh;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxRefreshTableHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxRefreshDataSourcesQuery
extends UxSchemaBuilderQuery {
    public UxRefreshDataSourcesQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxDataSourcesRefresh status = UxRefreshTableHelper.refresh(queryContext, lock, schema, null, null);
            if (status != null && status.isUpdated()) {
                service.saveSchemaDef(queryContext.getUserName(), lock, schema, "refresh all datasources columns");
                return UxReply.actionSuccess((UxActionResult)status, new UxActionContinuation(UxActionContinuationKind.RESULT));
            }
            return UxReply.actionSuccess();
        });
    }
}

