/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.common.UxProperties;
import crazydev.iccube.ux.builder.common.UxProperty;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.IOException;
import java.io.StringReader;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class UxJdbcDataSourceAdvPropsQuery
extends UxBuilderQuery {
    private final OlapBuilderDriverType driver;
    @Nullable
    private String url;
    @Nullable
    private final String props;

    public UxJdbcDataSourceAdvPropsQuery(UxQueryMeta meta, OlapRequestId requestId, OlapBuilderDriverType driver, @Nullable String url, @Nullable String props) {
        super(meta, requestId);
        this.driver = driver;
        this.url = url;
        this.props = props;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        ArrayList<UxProperty> uProps = new ArrayList<UxProperty>();
        try {
            Properties userDefinedProps = new Properties();
            if (CdStringUtils.isNotNullAndNotBlank((String)this.props)) {
                userDefinedProps.load(new StringReader(this.props));
            }
            for (Map.Entry<Object, Object> entry : userDefinedProps.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                uProps.add(new UxProperty(name, value));
            }
        }
        catch (IOException userDefinedProps) {
            // empty catch block
        }
        ArrayList<UxProperty> dProps = new ArrayList<UxProperty>();
        List driverPropertyInfos = this.driver.getJdbcProperties(this.url);
        for (DriverPropertyInfo info : driverPropertyInfos) {
            dProps.add(new UxProperty(info));
        }
        return UxReply.actionSuccess(new UxProperties(uProps, dProps));
    }
}

