/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.cube;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.queries.cube.UxCubeQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.io.Serializable;

public class UxSaveCubeExQuery
extends UxSchemaBuilderQuery {
    private final UxModel model;

    public UxSaveCubeExQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxModel model) {
        super(meta, requestId, schemaId);
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderCubeDef cube = (IOlapBuilderCubeDef)converter.convertToServerModel(queryContext, this.model);
            schema.insertCube(lock, cube);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "add cube: " + cube.getName());
            UxUseCase cubeUC = UxCubeQueryMeta.createUseCase(queryContext, UxActionSetup.NONE, this.schemaId, null, UxBuilderCubeUniqueName.create(cube));
            return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, cubeUC));
        });
    }
}

