/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.colors;

import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.colors.UxSaveSchemaColorsQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxSchemaColorsQuery
extends UxSchemaBuilderQuery {
    public UxSchemaColorsQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            int revNumber = schema.getRevNumber();
            IOlapBuilderColorsDef colors = schema.getColors(lock);
            UxModel model = queryContext.convertToUxModel(revNumber, colors);
            UxAction save = UxSaveSchemaColorsQueryMeta.createAction(queryContext, this.schemaId);
            return UxReply.success(new UxModelReplyPayload(model, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.SchemaColors, this.schemaId));
    }
}

