/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderEntityUniqueName;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDeleteSchemaEntitiesQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderUseCaseName useCase;
    private final List<UxBuilderEntityUniqueName> names;

    public UxDeleteSchemaEntitiesQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderUseCaseName useCase, @Nullable List<UxBuilderEntityUniqueName> names) {
        super(meta, requestId, schemaId);
        this.useCase = useCase;
        this.names = names != null ? names : new ArrayList();
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            if (!this.names.isEmpty()) {
                schema.deleteEntities(lock, this.useCase, this.names);
                service.saveSchemaDef(queryContext.getUserName(), lock, schema, "delete (" + this.names.size() + ") entities");
            }
            UxActionContinuation continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, queryContext.getUseCase(this.useCase, this.schemaId));
            return UxReply.actionSuccess(continuation);
        });
    }
}

