/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.model;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.mdx.parser.MdxParserIdentifierHelper;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.ux.builder.model.UxBuilderUniqueNameError;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class UxBuilderUniqueName {
    private final String uuid;
    private final List<String> parts;

    protected UxBuilderUniqueName(String uuid, List<String> parts) {
        this.uuid = uuid;
        this.parts = parts;
        if (CdStringUtils.isNullOrBlank((String)uuid)) {
            throw new UxBuilderUniqueNameError("unexpected URL missing part : " + UxBuilderUniqueName.asErrorForMissingPart(parts));
        }
    }

    private static String asErrorForMissingPart(List<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < parts.size(); ++ii) {
            String part = parts.get(ii);
            if (ii > 0) {
                sb.append(" / ");
            }
            if (!CdStringUtils.isNotNullAndNotBlank((String)part)) continue;
            sb.append(part);
        }
        return sb.toString();
    }

    protected String getPart(int index) {
        String part = null;
        if (index < this.parts.size()) {
            part = this.parts.get(index);
        }
        return part != null ? part : "";
    }

    protected static String createUuidFromUrlParam(String param, String value) throws UxQueryParserException {
        int pos = value.lastIndexOf(58);
        if (pos == -1) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{param, value});
        }
        String uuid = value.substring(pos + 1);
        return uuid;
    }

    protected static List<String> createPartsFromUrlParam(String param, String value) throws UxQueryParserException {
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return new ArrayList<String>();
        }
        int pos = value.lastIndexOf(58);
        String valueParts = pos != -1 ? value.substring(0, pos) : value;
        OlapEntityIdentifier id = MdxParserIdentifierHelper.parseIdentifier((boolean)true, (String)valueParts, (String)("unique name (" + param + ")"));
        if (id == null || id.isKey()) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{param, value});
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (int ii = 0; ii < id.getPartCount(); ++ii) {
            parts.add(id.getPart(ii).asName());
        }
        return parts;
    }

    public String asUUID() {
        return this.uuid;
    }

    public String asUrlParam() {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < this.parts.size(); ++ii) {
            String part = this.parts.get(ii);
            if (ii > 0) {
                sb.append(".");
            }
            if (CdStringUtils.isNullOrBlank((String)part)) {
                sb.append("[]");
                continue;
            }
            sb.append("[").append(CdMdxUtils.escape((String)part)).append("]");
        }
        sb.append(":").append(this.uuid);
        return sb.toString();
    }

    public String asString() {
        return this.asUrlParam();
    }

    public String toString() {
        return this.asUrlParam();
    }
}

