/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.model;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.facts.OlapBuilderBaseFacts;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTabularDataBasedDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTableUsedBy;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import java.io.Serializable;
import java.util.List;

public abstract class UxBuilderSchemaConstraintHelper {
    private UxBuilderSchemaConstraintHelper() {
    }

    public static void onDataSourceDeletion(UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataSource dataSource) throws UxBuilderSchemaServiceException {
        List dataTables = dataSource.getTables();
        if (dataTables != null && !dataTables.isEmpty()) {
            for (OlapBuilderBaseDataTable dataTable : dataTables) {
                UxBuilderSchemaConstraintHelper.onTableDeletion(lock, schema, (IOlapBuilderDataTableDef)dataTable);
            }
        }
    }

    public static void onTableDeletion(UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataTableDef table) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaConstraintHelper.onTabularDataDeletion(lock, schema, (IOlapBuilderTabularDataDef)table);
    }

    public static void onViewDeletion(UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataViewDef view) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaConstraintHelper.onTabularDataDeletion(lock, schema, (IOlapBuilderTabularDataDef)view);
    }

    public static void onTabularDataDeletion(UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef data) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaConstraintHelper.onTabularDataUsage(lock, schema, (uuid, entity) -> {
            if (data.getId().equals(uuid)) {
                if (entity instanceof IOlapBuilderLocalizationDef || entity instanceof IOlapBuilderColorsDef) {
                    UxBuilderSchemaConstraintHelper.onConstraintErrorEx(UxBuilderSchemaConstraintHelper.tableOrView(data), data.getName(), entity.getUsedByTag().name());
                } else {
                    UxBuilderSchemaConstraintHelper.onConstraintError(UxBuilderSchemaConstraintHelper.tableOrView(data), data.getName(), entity.getUsedByTag().name(), entity.getName());
                }
            }
        });
    }

    private static String tableOrView(IOlapBuilderTabularDataDef data) {
        return data instanceof IOlapBuilderDataTableDef ? "table" : "view";
    }

    private static void onConstraintError(String type, String name, String usedByType, String usedByName) throws UxBuilderSchemaServiceException {
        throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_CONSTRAINT_ERROR, (Serializable[])new Serializable[]{type, name, usedByType, usedByName}));
    }

    private static void onConstraintErrorEx(String type, String name, String usedByType) throws UxBuilderSchemaServiceException {
        throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_CONSTRAINT_ERROR_EX, (Serializable[])new Serializable[]{type, name, usedByType}));
    }

    public static void onDimensionDeletion(UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDimensionDef dimension) {
        schema.forEachMeasureGroups(lock, facts -> {
            if (facts.measureGroup instanceof OlapBuilderBaseFacts) {
                ((OlapBuilderBaseFacts)facts.measureGroup).removeLink(dimension);
            }
        });
    }

    public static void onTabularDataUsage(UxBuilderSchemaLock lock, UxBuilderSchema schema, UxBuilderTableUsedBy cb) throws UxBuilderSchemaServiceException {
        IOlapBuilderLocalizationDef localization = schema.getLocalization(lock);
        cb.onUsedBy(localization.getDataTableId(), (IOlapBuilderUsedByDef)localization);
        IOlapBuilderColorsDef colors = schema.getColors(lock);
        cb.onUsedBy(colors.getDataTableId(), (IOlapBuilderUsedByDef)colors);
        schema.forEachDimension(lock, dim -> {
            OlapBuilderTimeWizardDimension wizardDimension;
            String dataTableId;
            if (dim instanceof OlapBuilderTabularDataBasedDimension) {
                cb.onUsedBy(dim.getDataTableId(), (IOlapBuilderUsedByDef)dim);
            } else if (dim instanceof OlapBuilderTimeWizardDimension && CdStringUtils.isNotNullAndNotBlank((String)(dataTableId = (wizardDimension = (OlapBuilderTimeWizardDimension)dim).getDataTableId()))) {
                cb.onUsedBy(dataTableId, (IOlapBuilderUsedByDef)dim);
            }
        });
        schema.forEachMeasureGroups(lock, facts -> {
            if (facts.measureGroup instanceof OlapBuilderBaseFacts) {
                ((OlapBuilderBaseFacts)facts.measureGroup).setCube(facts.cube);
                cb.onUsedBy(facts.measureGroup.getDataTableId(), (IOlapBuilderUsedByDef)facts.measureGroup);
            }
        });
        schema.forEachView(lock, view -> {
            List internalTabularDataIds = view.getInternalTabularDataIds();
            for (String id : internalTabularDataIds) {
                cb.onUsedBy(id, (IOlapBuilderUsedByDef)view);
            }
        });
        schema.forEachBridge(lock, bridge -> {
            List<String> tableIds = bridge.getTableIds();
            for (String tableId : tableIds) {
                cb.onUsedBy(tableId, (IOlapBuilderUsedByDef)bridge);
            }
        });
    }
}

