/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.model;

import crazydev.common.collection.CdCollections;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdMutableInt;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.datasource.facts.OlapBuilderBaseFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderLinkXmlDefinition;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.OlapBuilderBaseSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderCube;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderStatisticalDimension;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseWithAllHierarchy;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.ux.builder.common.UxLazyTreeKind;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderBridge;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderEntityUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHasRevNumber;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyReference;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderLevelReference;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaConstraintHelper;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaProps;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaUsageHelper;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.model.UxBuilderTabularDataUsage;
import crazydev.iccube.ux.builder.model.UxConsumer;
import crazydev.iccube.ux.builder.model.UxExtraNavigationNode;
import crazydev.iccube.ux.builder.model.UxExtraNavigationNodeId;
import crazydev.iccube.ux.builder.model.UxExtraNavigationTree;
import crazydev.iccube.ux.builder.model.UxExtraNavigationUseCaseSetup;
import crazydev.iccube.ux.builder.model.UxSchemaInfoR;
import crazydev.iccube.ux.builder.model.UxTabularInfo;
import crazydev.iccube.ux.builder.model.UxTabularInfos;
import crazydev.iccube.ux.builder.model.UxTabularName;
import crazydev.iccube.ux.builder.model.UxTabularNames;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxLevelKeyPart;
import crazydev.iccube.ux.builder.queries.measures.UxMeasuresQueryMeta;
import crazydev.iccube.ux.builder.queries.semanticlayer.UxSemanticLayerQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.mdx.queries.browser.result.UxSchemaBrowsingNodeType;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UxBuilderSchema
implements UxBuilderHasRevNumber {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final OlapBuilderBaseSchemaDefFactory factory;
    private final OlapBuilderSchema definition;

    public UxBuilderSchema(OlapBuilderBaseSchemaDefFactory factory) {
        this.factory = factory;
        this.definition = (OlapBuilderSchema)factory.getSchemaDefinition();
    }

    public Lock readLock() {
        return this.lock.readLock();
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public int getRevNumber() {
        return this.factory.getRevisionNumber();
    }

    @Override
    public void setRevNumber(int revNumber) {
        throw new RuntimeException("internal error: cannot set rev-number to UX schema");
    }

    public String getName() {
        return this.definition.getName();
    }

    public OlapSchemaFactoryInfo getInfo() {
        return new OlapSchemaFactoryInfo(this.factory.getXmlFile(), this.factory.getRevisionNumber(), this.definition.getName(), this.definition.getGroup(), this.definition.getDescription(), this.definition.isLoadOnStartup());
    }

    public OlapBuilderBaseSchemaDefFactory getFactory() {
        return this.factory;
    }

    public OlapBuilderSchema getDefinition(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition;
    }

    public boolean incrLoadActive(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition.activateIncrementalLoad();
    }

    public boolean useFactPartitioning(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition.useFactPartitioning();
    }

    public <E extends Exception> void forEachDimension(UxBuilderSchemaLock lock, UxConsumer<IOlapBuilderDimensionDef, E> visitor) throws E {
        for (IOlapBuilderDimensionDef dimension : this.definition.getDimensions()) {
            visitor.accept(dimension);
        }
    }

    public <E extends Exception> void forEachCubes(UxBuilderSchemaLock lock, UxConsumer<IOlapBuilderCubeDef, E> visitor) throws E {
        lock.assertForReadAccess(this);
        for (IOlapBuilderCubeDef cube : this.definition.getCubes()) {
            visitor.accept(cube);
        }
    }

    public <E extends Exception> void forEachMeasureGroups(UxBuilderSchemaLock lock, UxConsumer<UxBuilderMeasureGroupReference, E> visitor) throws E {
        lock.assertForReadAccess(this);
        for (IOlapBuilderCubeDef cube : this.definition.getCubes()) {
            for (IOlapBuilderBaseFactsDef facts : cube.getFacts()) {
                visitor.accept(new UxBuilderMeasureGroupReference(cube, facts));
            }
        }
    }

    public <E extends Exception> void forEachSortedMeasureGroups(UxBuilderSchemaLock lock, UxConsumer<UxBuilderMeasureGroupReference, E> visitor) throws E {
        lock.assertForReadAccess(this);
        for (IOlapBuilderCubeDef cube : this.definition.getCubes()) {
            ArrayList<IOlapBuilderBaseFactsDef> sortedFacts = new ArrayList<IOlapBuilderBaseFactsDef>(cube.getFacts());
            sortedFacts.sort(Comparator.comparing(IOlapBuilderBaseFactsDef::getMeasureGroupName));
            for (IOlapBuilderBaseFactsDef facts : sortedFacts) {
                visitor.accept(new UxBuilderMeasureGroupReference(cube, facts));
            }
        }
    }

    public <E extends Exception> void forEachBridge(UxBuilderSchemaLock lock, UxConsumer<UxBuilderBridge, E> visitor) throws E {
        lock.assertForReadAccess(this);
        Map dimensions = null;
        for (IOlapBuilderCubeDef cube : this.definition.getCubes()) {
            for (IOlapBuilderBaseFactsDef facts_ : cube.getFacts()) {
                if (!(facts_ instanceof OlapBuilderBaseFacts)) continue;
                OlapBuilderBaseFacts facts = (OlapBuilderBaseFacts)facts_;
                List xmlLinks = facts.getLinks();
                for (OlapBuilderLinkXmlDefinition xmlLink : xmlLinks) {
                    IOlapBuilderDataViewLinksDef link = xmlLink.getLink();
                    if (!link.isBridge()) continue;
                    String dimensionId = xmlLink.getDimensionId();
                    if (dimensions == null) {
                        dimensions = this.definition.getDimensions().stream().collect(Collectors.toMap(IOlapBuilderDimensionDef::getId, Function.identity()));
                    }
                    IOlapBuilderDimensionDef dimension = this.definition.getDimensionByUUID(dimensionId);
                    visitor.accept(new UxBuilderBridge(cube, (IOlapBuilderBaseFactsDef<?, ?>)facts, (IOlapBuilderDimensionDef<?>)dimension, link));
                }
            }
        }
    }

    public <E extends Exception> void forEachTable(UxBuilderSchemaLock lock, UxConsumer<UxBuilderTableReference, E> visitor) throws E {
        lock.assertForReadAccess(this);
        for (IOlapBuilderDataSource dataSource : this.definition.getDataSources()) {
            List tables = dataSource.getTables();
            for (IOlapBuilderDataTableDef table : tables) {
                table.setDataSource(dataSource);
                visitor.accept(new UxBuilderTableReference(dataSource, table));
            }
        }
    }

    public <E extends Exception> void forEachView(UxBuilderSchemaLock lock, UxConsumer<IOlapBuilderDataViewDef, E> visitor) throws E {
        lock.assertForReadAccess(this);
        for (IOlapBuilderDataViewDef view : this.definition.getViews()) {
            visitor.accept(view);
        }
    }

    public <E extends Exception> void forEachTabularData(UxBuilderSchemaLock lock, UxConsumer<IOlapBuilderTabularDataDef, E> visitor) throws E {
        lock.assertForReadAccess(this);
        this.forEachTable(lock, table -> visitor.accept((IOlapBuilderTabularDataDef)table.table));
        this.forEachView(lock, visitor::accept);
    }

    public UxTabularNames getTabularNames(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        Map<String, CdMutableInt> nameUsage = this.tabularNameUsage(lock);
        ArrayList<UxTabularName> names = new ArrayList<UxTabularName>();
        this.forEachTable(lock, table -> {
            CdMutableInt count = (CdMutableInt)nameUsage.get(table.table.getName());
            Object caption = count != null && count.value > 1 ? table.table.getName() + " ( " + table.dataSource.getName() + " )" : table.table.getName();
            names.add(new UxTabularName(table.table.getId(), (String)caption));
        });
        this.forEachView(lock, view -> names.add(new UxTabularName(view.getId(), view.getName())));
        names.sort(Comparator.comparing(UxTabularName::getCaption));
        return new UxTabularNames(names);
    }

    public UxTabularInfos getTabularInfos(UxBuilderSchemaLock lock, OlapBabylonService babylon, String uuid) {
        lock.assertForReadAccess(this);
        Map<String, CdMutableInt> nameUsage = this.tabularNameUsage(lock);
        ArrayList<UxTabularInfo> infos = new ArrayList<UxTabularInfo>();
        this.forEachTable(lock, table -> {
            CdMutableInt count = (CdMutableInt)nameUsage.get(table.table.getName());
            Object caption = count != null && count.value > 1 ? table.table.getName() + " ( " + table.dataSource.getName() + " )" : table.table.getName();
            UxTabularName name = new UxTabularName(table.table.getId(), (String)caption);
            List selectedColumns = table.table.getSortedSelectedColumnsUX();
            List<UxLevelKeyPart> columns = selectedColumns.stream().map(col -> UxLevelKeyPart.create(babylon, false, col)).collect(Collectors.toList());
            infos.add(new UxTabularInfo(name, columns));
        });
        this.forEachView(lock, view -> {
            UxTabularName name = new UxTabularName(view.getId(), view.getName());
            List<UxLevelKeyPart> columns = view.getSelectedColumnsForUX().stream().map(col -> UxLevelKeyPart.create(babylon, false, col)).collect(Collectors.toList());
            infos.add(new UxTabularInfo(name, columns));
        });
        infos.sort((o1, o2) -> {
            String c1 = o1.getCaption();
            String c2 = o2.getCaption();
            return c1.compareToIgnoreCase(c2);
        });
        return new UxTabularInfos(infos, uuid);
    }

    private Map<String, CdMutableInt> tabularNameUsage(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        HashMap<String, CdMutableInt> captions = new HashMap<String, CdMutableInt>();
        this.forEachTable(lock, table -> ++captions.computeIfAbsent(table.table.getName(), (Function<String, CdMutableInt>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$tabularNameUsage$1(java.lang.String ), (Ljava/lang/String;)Lcrazydev/common/utils/CdMutableInt;)()).value);
        this.forEachView(lock, view -> ++captions.computeIfAbsent(view.getName(), (Function<String, CdMutableInt>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$tabularNameUsage$3(java.lang.String ), (Ljava/lang/String;)Lcrazydev/common/utils/CdMutableInt;)()).value);
        return captions;
    }

    public UxBuilderSchemaProps getProps(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return new UxBuilderSchemaProps(this.definition);
    }

    public List<IOlapBuilderDataSource> getDataSources(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition.getDataSources();
    }

    public List<IOlapBuilderDataSource> getSortedDataSources(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        ArrayList<IOlapBuilderDataSource> sources = new ArrayList<IOlapBuilderDataSource>(this.definition.getDataSources());
        sources.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return sources;
    }

    public IOlapBuilderDataSource getExistingDataSource(UxBuilderSchemaLock lock, String name) throws UxBuilderSchemaServiceException {
        IOlapBuilderDataSource ds = this.getDataSource(lock, name);
        if (ds == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"data source", name}));
        }
        return ds;
    }

    @Nullable
    public IOlapBuilderDataSource getDataSource(UxBuilderSchemaLock lock, String name) {
        lock.assertForReadAccess(this);
        IOlapBuilderDataSource ds = this.definition.getDataSource(name);
        return ds;
    }

    @Nullable
    public IOlapBuilderDataSource getOnlyDataSource(UxBuilderSchemaLock lock) throws UxBuilderSchemaServiceException {
        List<IOlapBuilderDataSource> dataSources = this.getDataSources(lock);
        if (dataSources != null && dataSources.size() == 1) {
            return dataSources.get(0);
        }
        return null;
    }

    public int getDataSourceCount(UxBuilderSchemaLock lock) throws UxBuilderSchemaServiceException {
        List<IOlapBuilderDataSource> dataSources = this.getDataSources(lock);
        return dataSources != null ? dataSources.size() : 0;
    }

    public void insertDataSource(UxBuilderSchemaLock lock, IOlapBuilderDataSource dataSource) {
        lock.assertForWriteAccess(this);
        if (this.definition.getDataSource(dataSource.getName()) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATASOURCE_NAME_DUPLICATED, new Serializable[]{dataSource.getName()});
        }
        this.definition.addDataSource(dataSource);
    }

    public IOlapBuilderDataSource renameDataSource(UxBuilderSchemaLock lock, String name, String newName) {
        lock.assertForWriteAccess(this);
        IOlapBuilderDataSource dataSource = this.getExistingDataSource(lock, name);
        if (this.definition.getDataSource(newName) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATASOURCE_NAME_DUPLICATED, new Serializable[]{newName});
        }
        dataSource.setName(newName);
        return dataSource;
    }

    public void deleteDataSource(UxBuilderSchemaLock lock, String name) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        IOlapBuilderDataSource dataSource = this.getExistingDataSource(lock, name);
        if (dataSource != null) {
            UxBuilderSchemaConstraintHelper.onDataSourceDeletion(lock, this, dataSource);
            this.definition.removeDataSource(dataSource);
        }
    }

    @Nullable
    public UxBuilderTableReference getDataTable(UxBuilderSchemaLock lock, UxBuilderTablePathName name) {
        lock.assertForReadAccess(this);
        UxBuilderTableReference[] tables = new UxBuilderTableReference[1];
        this.forEachTable(lock, table -> {
            if (table.dataSource.getName().equals(name.getDataSourceName()) && table.table.getName().equals(name.getTableName())) {
                tables[0] = table;
                table.table.setDataSource(table.dataSource);
            }
        });
        return tables[0];
    }

    public UxBuilderTableReference getExistingDataTableByUUID(UxBuilderSchemaLock lock, String uuid) {
        UxBuilderTableReference table = this.getDataTableByUUID(lock, uuid);
        if (table == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_NOT_FOUND, new Serializable[]{uuid});
        }
        return table;
    }

    public IOlapBuilderTabularDataDef getExistingDataTableOrViewByUUID(UxBuilderSchemaLock lock, IOlapBuilderSchemaDef schemaDef, String uuid) {
        UxBuilderTableReference table = this.getDataTableByUUID(lock, uuid);
        if (table == null) {
            IOlapBuilderDataViewDef view = this.getDataViewByUUID(lock, uuid);
            if (view == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_NOT_FOUND, new Serializable[]{uuid});
            }
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schemaDef, (IOlapBuilderDataViewDef)view);
            return view;
        }
        return table.table;
    }

    public IOlapBuilderTabularDataDef getExistingDataTableOrViewByName(UxBuilderSchemaLock lock, IOlapBuilderSchemaDef schemaDef, String name) {
        UxBuilderTableReference table = this.getDataTableByName(lock, name);
        if (table == null) {
            IOlapBuilderDataViewDef view = this.getDataViewByName(lock, name);
            if (view == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_NOT_FOUND, new Serializable[]{name});
            }
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schemaDef, (IOlapBuilderDataViewDef)view);
            return view;
        }
        return table.table;
    }

    public UxBuilderTableReference getExistingDataTableByName(UxBuilderSchemaLock lock, String name) {
        UxBuilderTableReference table = this.getDataTableByName(lock, name);
        if (table == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_NOT_FOUND, new Serializable[]{name});
        }
        return table;
    }

    @Nullable
    public UxBuilderTableReference getDataTableByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        UxBuilderTableReference[] tables = new UxBuilderTableReference[1];
        this.forEachTable(lock, table -> {
            if (table.table.getId().equals(uuid)) {
                tables[0] = table;
            }
        });
        return tables[0];
    }

    @Nullable
    public UxBuilderTableReference getDataTableByName(UxBuilderSchemaLock lock, String name) {
        lock.assertForReadAccess(this);
        UxBuilderTableReference[] tables = new UxBuilderTableReference[1];
        this.forEachTable(lock, table -> {
            if (table.table.getName().equals(name)) {
                tables[0] = table;
            }
        });
        return tables[0];
    }

    public void insertDataTable(UxBuilderSchemaLock lock, String dataSourceName, IOlapBuilderDataTableDef table) {
        lock.assertForWriteAccess(this);
        IOlapBuilderDataSource existingDataSource = this.getExistingDataSource(lock, dataSourceName);
        OlapBuilderBaseDataSource existingDataSourceR = (OlapBuilderBaseDataSource)existingDataSource;
        if (existingDataSource.getTableByName(table.getName()) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATATABLE_NAME_DUPLICATED, new Serializable[]{table.getName()});
        }
        existingDataSourceR.addTable(table);
    }

    public UxBuilderTableReference renameDataTable(UxBuilderSchemaLock lock, UxBuilderTablePathName name, String newName) {
        lock.assertForWriteAccess(this);
        UxBuilderTableReference table = this.getDataTable(lock, name);
        if (table == null) {
            throw new RuntimeException("missing table [" + String.valueOf(name) + "]");
        }
        if (table.dataSource.getTableByName(newName) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATATABLE_NAME_DUPLICATED, new Serializable[]{newName});
        }
        table.table.setName(newName);
        return table;
    }

    public void deleteDataTable(UxBuilderSchemaLock lock, UxBuilderTablePathName name) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        UxBuilderTableReference table = this.getDataTable(lock, name);
        this.doDeleteDataTable(lock, table);
    }

    public int deleteDataTablesNotUsed(UxBuilderSchemaLock lock) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        int count = 0;
        UxBuilderTabularDataUsage usages = UxBuilderSchemaUsageHelper.getUsageAllTables(lock, this, null);
        for (String notUsed : usages.getNotUsed()) {
            UxBuilderTableReference table = this.getDataTableByUUID(lock, notUsed);
            count += this.doDeleteDataTable(lock, table);
        }
        return count;
    }

    private int doDeleteDataTable(UxBuilderSchemaLock lock, @Nullable UxBuilderTableReference table) {
        if (table != null) {
            OlapBuilderBaseDataSource ds;
            UxBuilderSchemaConstraintHelper.onTableDeletion(lock, this, table.table);
            if (table.dataSource instanceof OlapBuilderBaseDataSource && (ds = (OlapBuilderBaseDataSource)table.dataSource).removeTable(table.table)) {
                return 1;
            }
        }
        return 0;
    }

    @Nullable
    public IOlapBuilderDataViewDef getDataViewByName(UxBuilderSchemaLock lock, String name) {
        lock.assertForReadAccess(this);
        IOlapBuilderDataViewDef[] views = new IOlapBuilderDataViewDef[1];
        this.forEachView(lock, view -> {
            if (view.getName().equals(name)) {
                views[0] = view;
            }
        });
        return views[0];
    }

    @Nullable
    public IOlapBuilderDataViewDef getDataViewByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        IOlapBuilderDataViewDef[] views = new IOlapBuilderDataViewDef[1];
        this.forEachView(lock, view -> {
            if (view.getId().equals(uuid)) {
                views[0] = view;
            }
        });
        return views[0];
    }

    public void insertDataView(UxBuilderSchemaLock lock, IOlapBuilderDataViewDef view) {
        lock.assertForWriteAccess(this);
        if (this.definition.getView(view.getName()) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_VIEW_NAME_DUPLICATED, new Serializable[]{view.getName()});
        }
        this.definition.addDataView(view);
    }

    public IOlapBuilderDataViewDef renameDataView(UxBuilderSchemaLock lock, String name, String newName) {
        lock.assertForWriteAccess(this);
        IOlapBuilderDataViewDef view = this.getDataViewByName(lock, name);
        if (view == null) {
            throw new RuntimeException("missing view [" + name + "]");
        }
        if (this.definition.getView(newName) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_VIEW_NAME_DUPLICATED, new Serializable[]{newName});
        }
        view.setName(newName);
        return view;
    }

    public void deleteDataView(UxBuilderSchemaLock lock, String name) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        IOlapBuilderDataViewDef view = this.getDataViewByName(lock, name);
        this.doDeleteDataView(lock, view);
    }

    public int deleteDataViewsNotUsed(UxBuilderSchemaLock lock) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        int count = 0;
        UxBuilderTabularDataUsage usages = UxBuilderSchemaUsageHelper.getUsageAllViews(lock, this, null);
        for (String notUsed : usages.getNotUsed()) {
            IOlapBuilderDataViewDef view = this.getDataViewByUUID(lock, notUsed);
            count += this.doDeleteDataView(lock, view);
        }
        return count;
    }

    private int doDeleteDataView(UxBuilderSchemaLock lock, @Nullable IOlapBuilderDataViewDef view) {
        if (view != null) {
            UxBuilderSchemaConstraintHelper.onViewDeletion(lock, this, view);
            if (this.definition.removeDataView(view)) {
                return 1;
            }
        }
        return 0;
    }

    @Nullable
    public IOlapBuilderTabularDataDef getTabularData(UxBuilderSchemaLock lock, @Nullable String uuid) {
        if (uuid == null) {
            return null;
        }
        lock.assertForReadAccess(this);
        if (CdStringUtils.isNullOrBlank((String)uuid)) {
            return null;
        }
        IOlapBuilderTabularDataDef[] data = new IOlapBuilderTabularDataDef[1];
        this.forEachTable(lock, table -> {
            if (uuid.equals(table.getTableId())) {
                data[0] = table.table;
            }
        });
        if (data[0] != null) {
            return data[0];
        }
        this.forEachView(lock, view -> {
            if (uuid.equals(view.getId())) {
                data[0] = view;
            }
        });
        return data[0];
    }

    public void switchTabularDataUsage(UxBuilderSchemaLock lock, IOlapBuilderTabularDataDef fromTable, IOlapBuilderTabularDataDef toTable) {
        lock.assertForWriteAccess(this);
        if (fromTable.equals((Object)toTable)) {
            return;
        }
        String fromId = fromTable.getId();
        String toId = toTable.getId();
        fromTable.setId(toId);
        toTable.setId(fromId);
        if (toTable instanceof OlapBuilderBaseDataView) {
            ((OlapBuilderBaseDataView)toTable).undoSwitchTableIfColliding(toId);
        }
        if (fromTable instanceof OlapBuilderBaseDataView) {
            ((OlapBuilderBaseDataView)fromTable).undoSwitchTableIfColliding(fromId);
        }
    }

    public UxExtraNavigationTree getSemanticLayerExtraNavigation(UxQueryContext context, UxBuilderSchemaLock lock, UxSchemaId schemaId, UxLazyTreeKind navTreeKind, String navTreeUUID, UxExtraNavigationUseCaseSetup action) {
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] schema.getSemanticLayerExtraNavigation( " + this.getName() + " ) started"));
        lock.assertForReadAccess(this);
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxExtraNavigationNode> nodes = new ArrayList<UxExtraNavigationNode>();
        ArrayList dimensions = new ArrayList(this.definition.getDimensions());
        Comparator comparator = OlapSchema.getNameComparator((Locale)context.getUxBabylonService().getLocale());
        dimensions.sort((o1, o2) -> {
            String n1 = o1.getName() != null ? o1.getName() : "";
            String n2 = o2.getName() != null ? o2.getName() : "";
            return comparator.compare(n1, n2);
        });
        for (IOlapBuilderDimensionDef dimension : dimensions) {
            ArrayList<UxExtraNavigationNode> hierarchyNodes = new ArrayList<UxExtraNavigationNode>();
            if (!(dimension instanceof OlapBuilderStatisticalDimension)) {
                List hierarchies = dimension.getHierarchies();
                Comparator comparator2 = OlapSchema.getNameComparator((Locale)context.getUxBabylonService().getLocale());
                hierarchies.sort((o1, o2) -> {
                    if (o1.isDefault()) {
                        return -1;
                    }
                    if (o2.isDefault()) {
                        return 1;
                    }
                    String n1 = o1.getName() != null ? o1.getName() : "";
                    String n2 = o2.getName() != null ? o2.getName() : "";
                    return comparator2.compare(n1, n2);
                });
                for (IOlapBuilderHierarchyDef hierarchy : hierarchies) {
                    ArrayList<UxExtraNavigationNode> levelNodes = new ArrayList<UxExtraNavigationNode>();
                    List levels = hierarchy.getLevelsForUX();
                    if (levels != null) {
                        for (IOlapBuilderBaseHierarchyLevelDef level : levels) {
                            UxUseCase levelUC = action.setup(dimension, hierarchy, level);
                            String levelTooltip = level.getTooltipForLevel();
                            levelNodes.add(new UxExtraNavigationNode(UxExtraNavigationNodeId.create(UxBuilderLevelUniqueName.create(dimension, hierarchy, level)), level.getName(), levelTooltip, UxSchemaBrowsingNodeType.Level, levelUC, Collections.emptyList()));
                        }
                    }
                    UxUseCase hierarchyUC = action.setup(dimension, hierarchy);
                    String hierarchyTooltip = null;
                    hierarchyNodes.add(new UxExtraNavigationNode(UxExtraNavigationNodeId.create(UxBuilderHierarchyUniqueName.create(dimension, hierarchy)), hierarchy.getName(), hierarchyTooltip, UxSchemaBrowsingNodeType.Hierarchy, hierarchyUC, levelNodes));
                }
            }
            UxUseCase dimensionUC = action.setup(dimension);
            UxBuilderTableReference dimTable = this.getDataTableByUUID(lock, dimension.getDataTableId());
            String dimensionTooltip = dimension.getName() + " - " + babylon.translate(dimension.getClass().getSimpleName(), new Serializable[0]) + (String)(dimTable == null ? "" : " (table: '" + dimTable.getTableName() + "' )");
            nodes.add(new UxExtraNavigationNode(UxExtraNavigationNodeId.create(UxBuilderDimensionUniqueName.create(dimension)), dimension.getName(), dimensionTooltip, UxSchemaBrowsingNodeType.Dimension, dimensionUC, hierarchyNodes));
        }
        List<UxAction> multiSelectionActions = UxSemanticLayerQueryMeta.createMultiSelectionActions(context, schemaId);
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] schema.getSemanticLayerExtraNavigation( " + this.getName() + " ) done"));
        return new UxExtraNavigationTree(null, navTreeKind, navTreeUUID, null, nodes, multiSelectionActions);
    }

    public UxExtraNavigationTree getMeasuresExtraNavigation(UxQueryContext context, UxBuilderSchemaLock lock, UxSchemaId schemaId, UxLazyTreeKind navTreeKind, String navTreeUUID, UxExtraNavigationUseCaseSetup action) {
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] schema.getMeasuresExtraNavigation( " + this.getName() + " ) started"));
        lock.assertForReadAccess(this);
        ArrayList<UxExtraNavigationNode> nodes = new ArrayList<UxExtraNavigationNode>();
        ArrayList cubes = new ArrayList(this.definition.getCubes());
        Comparator comparator = OlapSchema.getNameComparator((Locale)context.getUxBabylonService().getLocale());
        cubes.sort((o1, o2) -> {
            String n1 = o1.getName() != null ? o1.getName() : "";
            String n2 = o2.getName() != null ? o2.getName() : "";
            return comparator.compare(n1, n2);
        });
        for (IOlapBuilderCubeDef cube : cubes) {
            ArrayList<UxExtraNavigationNode> measureGroupsNodes = new ArrayList<UxExtraNavigationNode>();
            ArrayList measureGroups = new ArrayList(cube.getFacts());
            Comparator comparator2 = OlapSchema.getNameComparator((Locale)context.getUxBabylonService().getLocale());
            measureGroups.sort((o1, o2) -> {
                String n1 = o1.getName() != null ? o1.getName() : "";
                String n2 = o2.getName() != null ? o2.getName() : "";
                return comparator2.compare(n1, n2);
            });
            for (IOlapBuilderBaseFactsDef measureGroup : measureGroups) {
                ArrayList<UxExtraNavigationNode> measureNodes = new ArrayList<UxExtraNavigationNode>();
                List measures = measureGroup.getMeasures();
                if (measures != null) {
                    for (IOlapBuilderMeasureDef measure : measures) {
                        UxUseCase measureUC = action.setup(cube, measureGroup, measure);
                        measureNodes.add(new UxExtraNavigationNode(UxExtraNavigationNodeId.create(UxBuilderMeasureUniqueName.create(cube, measureGroup, measure)), measure.getName(), null, UxSchemaBrowsingNodeType.Measure, measureUC, Collections.emptyList()));
                    }
                }
                UxUseCase measureGroupUC = action.setup(cube, measureGroup);
                measureGroupsNodes.add(new UxExtraNavigationNode(UxExtraNavigationNodeId.create(UxBuilderMeasureGroupUniqueName.create(cube, measureGroup)), measureGroup.getName(), null, UxSchemaBrowsingNodeType.MeasureGroup, measureGroupUC, measureNodes));
            }
            UxUseCase cubeUC = action.setup(cube);
            nodes.add(new UxExtraNavigationNode(UxExtraNavigationNodeId.create(UxBuilderCubeUniqueName.create(cube)), cube.getName(), null, UxSchemaBrowsingNodeType.Cube, cubeUC, measureGroupsNodes));
        }
        List<UxAction> multiSelectionActions = UxMeasuresQueryMeta.createMultiSelectionActions(context, schemaId);
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] schema.getMeasuresExtraNavigation( " + this.getName() + " ) done"));
        return new UxExtraNavigationTree(null, navTreeKind, navTreeUUID, null, nodes, multiSelectionActions);
    }

    public void deleteEntities(UxBuilderSchemaLock lock, UxBuilderUseCaseName useCase, List<UxBuilderEntityUniqueName> names) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        block22: for (UxBuilderEntityUniqueName name : names) {
            switch (name.type) {
                case "Dimension": {
                    IOlapBuilderDimensionDef dimension = this.getDimensionByUUID(lock, name.uuid);
                    if (dimension == null) continue block22;
                    UxBuilderSchemaConstraintHelper.onDimensionDeletion(lock, this, dimension);
                    this.definition.removeDimension(dimension);
                    break;
                }
                case "Hierarchy": {
                    UxBuilderHierarchyReference hierarchy = this.getHierarchyByUUID(lock, name.uuid);
                    if (hierarchy == null) continue block22;
                    ((OlapBuilderBaseDimension)hierarchy.dimension).removeHierarchy(hierarchy.hierarchy);
                    break;
                }
                case "Level": {
                    UxBuilderLevelReference level = this.getLevelByUUID(lock, name.uuid);
                    if (level == null) continue block22;
                    level.hierarchy.removeLevelForUX(level.level);
                    break;
                }
                case "Cube": {
                    IOlapBuilderCubeDef cube = this.getCubeByUUID(lock, name.uuid);
                    if (cube == null) continue block22;
                    this.definition.removeCube(cube);
                    break;
                }
                case "MeasureGroup": {
                    IOlapBuilderCubeDef iOlapBuilderCubeDef;
                    UxBuilderMeasureGroupReference measureGroup = this.getMeasureGroupByUUID(lock, name.uuid);
                    if (measureGroup == null || !((iOlapBuilderCubeDef = measureGroup.cube) instanceof OlapBuilderCube)) continue block22;
                    OlapBuilderCube cubeB = (OlapBuilderCube)iOlapBuilderCubeDef;
                    cubeB.removeFacts(measureGroup.measureGroup);
                    break;
                }
                case "Measure": {
                    UxBuilderMeasureReference measure = this.getMeasureByUUID(lock, name.uuid);
                    if (measure == null) continue block22;
                    measure.measureGroup.removeMeasureForUX(measure.measure);
                    break;
                }
                case "DataTables": {
                    UxBuilderTableReference table = this.getDataTableByUUID(lock, name.uuid);
                    if (table == null) continue block22;
                    this.deleteDataTable(lock, UxBuilderTablePathName.create(table.dataSource, table.table));
                    break;
                }
                case "DataViews": {
                    IOlapBuilderDataViewDef view = this.getDataViewByUUID(lock, name.uuid);
                    if (view == null) continue block22;
                    this.deleteDataView(lock, view.getName());
                    break;
                }
                case "Perspectives": {
                    this.deletePerspective(lock, name.uuid);
                }
            }
        }
    }

    public boolean hasDimension(UxBuilderSchemaLock lock, String name) {
        lock.assertForReadAccess(this);
        return this.definition.hasDimension(name);
    }

    public IOlapBuilderDimensionDef getExistingDimension(UxBuilderSchemaLock lock, UxBuilderDimensionUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        IOlapBuilderDimensionDef dimension = this.getDimension(lock, name);
        if (dimension == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"dimension", name.asString()}));
        }
        return dimension;
    }

    @Nullable
    public IOlapBuilderDimensionDef getDimension(UxBuilderSchemaLock lock, UxBuilderDimensionUniqueName name) {
        return this.getDimensionByUUID(lock, name.asUUID());
    }

    @Nullable
    public IOlapBuilderDimensionDef getDimensionByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        return this.definition.getDimensionByUUID(uuid);
    }

    @Nullable
    public IOlapBuilderDimensionDef getDimensionByName(UxBuilderSchemaLock lock, String name) {
        lock.assertForReadAccess(this);
        return this.definition.getDimensionByName(name);
    }

    public IOlapBuilderDimensionDef renameDimension(UxBuilderSchemaLock lock, UxBuilderDimensionUniqueName name, String newName) {
        lock.assertForWriteAccess(this);
        IOlapBuilderDimensionDef dimension = this.getExistingDimension(lock, name);
        if (this.definition.hasDimension(newName)) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DIMENSION_DUPLICATED, new Serializable[]{newName});
        }
        dimension.setName(newName);
        return dimension;
    }

    public void deleteDimension(UxBuilderSchemaLock lock, UxBuilderDimensionUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        IOlapBuilderDimensionDef dimension = this.getExistingDimension(lock, name);
        if (dimension != null) {
            UxBuilderSchemaConstraintHelper.onDimensionDeletion(lock, this, dimension);
            this.definition.removeDimension(dimension);
        }
    }

    public void insertDimension(UxBuilderSchemaLock lock, IOlapBuilderDimensionDef dimension) {
        lock.assertForWriteAccess(this);
        if (this.definition.hasDimension(dimension.getName())) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DIMENSION_DUPLICATED, new Serializable[]{dimension.getName()});
        }
        this.definition.addDimension(dimension);
    }

    public void insertDimensions(UxBuilderSchemaLock lock, List<IOlapBuilderDimensionDef> dimensions) {
        lock.assertForWriteAccess(this);
        for (IOlapBuilderDimensionDef dimension : dimensions) {
            if (!this.definition.hasDimension(dimension.getName())) continue;
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DIMENSION_DUPLICATED, new Serializable[]{dimension.getName()});
        }
        for (IOlapBuilderDimensionDef dimension : dimensions) {
            this.definition.addDimension(dimension);
        }
    }

    public UxBuilderHierarchyReference getExistingHierarchy(UxBuilderSchemaLock lock, UxBuilderHierarchyUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        UxBuilderHierarchyReference hierarchy = this.getHierarchy(lock, name);
        if (hierarchy == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"hierarchy", name.toString()}));
        }
        return hierarchy;
    }

    @Nullable
    public UxBuilderHierarchyReference getHierarchy(UxBuilderSchemaLock lock, UxBuilderHierarchyUniqueName name) {
        return this.getHierarchyByUUID(lock, name.asUUID());
    }

    @Nullable
    public UxBuilderHierarchyReference getHierarchyByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        for (IOlapBuilderDimensionDef dimension : this.definition.getDimensions()) {
            IOlapBuilderHierarchyDef hierarchy = dimension.getHierarchyByUUID(uuid);
            if (hierarchy == null) continue;
            return new UxBuilderHierarchyReference(dimension, hierarchy);
        }
        return null;
    }

    public UxBuilderHierarchyReference renameHierarchy(UxBuilderSchemaLock lock, UxBuilderHierarchyUniqueName name, String newName) {
        lock.assertForWriteAccess(this);
        UxBuilderHierarchyReference hierarchy = this.getExistingHierarchy(lock, name);
        if (hierarchy.dimension.getHierarchy(newName) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HIERARCHY_NAME_DUPLICATED, new Serializable[]{newName});
        }
        hierarchy.hierarchy.setName(newName);
        return hierarchy;
    }

    public void deleteHierarchy(UxBuilderSchemaLock lock, UxBuilderHierarchyUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        UxBuilderHierarchyReference hierarchy = this.getExistingHierarchy(lock, name);
        ((OlapBuilderBaseDimension)hierarchy.dimension).removeHierarchy(hierarchy.hierarchy);
    }

    public UxBuilderLevelReference getExistingLevel(UxBuilderSchemaLock lock, UxBuilderLevelUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        UxBuilderLevelReference level = this.getLevel(lock, name);
        if (level == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"level", name.toString()}));
        }
        return level;
    }

    @Nullable
    public UxBuilderLevelReference getLevel(UxBuilderSchemaLock lock, UxBuilderLevelUniqueName name) {
        return this.getLevelByUUID(lock, name.asUUID());
    }

    @Nullable
    public UxBuilderLevelReference getLevelByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        for (IOlapBuilderDimensionDef dimension : this.definition.getDimensions()) {
            List hierarchies = dimension.getHierarchies();
            if (hierarchies == null) continue;
            for (IOlapBuilderHierarchyDef hierarchy : hierarchies) {
                IOlapBuilderBaseHierarchyLevelDef level = hierarchy.getLevelByUUIDForUX(uuid);
                if (level == null) continue;
                return new UxBuilderLevelReference(dimension, hierarchy, level);
            }
        }
        return null;
    }

    public void moveLevelUp(UxBuilderSchemaLock lock, UxBuilderLevelUniqueName name) {
        lock.assertForWriteAccess(this);
        UxBuilderLevelReference level = this.getExistingLevel(lock, name);
        level.hierarchy.moveLevelUp(level.level);
    }

    public void moveLevelDown(UxBuilderSchemaLock lock, UxBuilderLevelUniqueName name) {
        lock.assertForWriteAccess(this);
        UxBuilderLevelReference level = this.getExistingLevel(lock, name);
        level.hierarchy.moveLevelDown(level.level);
    }

    public UxBuilderLevelReference renameLevel(UxBuilderSchemaLock lock, UxBuilderLevelUniqueName name, String newName) {
        lock.assertForWriteAccess(this);
        UxBuilderLevelReference level = this.getExistingLevel(lock, name);
        if (level.hierarchy.getLevelForUX(newName) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LEVEL_NAME_DUPLICATED, new Serializable[]{newName});
        }
        level.level.setName(newName);
        return level;
    }

    public void deleteLevel(UxBuilderSchemaLock lock, UxBuilderLevelUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        UxBuilderLevelReference level = this.getExistingLevel(lock, name);
        level.hierarchy.removeLevelForUX(level.level);
    }

    public Set<String> getCubeNames(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        List cubes = this.definition.getCubes();
        return cubes.stream().map(IOlapBuilderCubeDef::getName).collect(Collectors.toSet());
    }

    @Nullable
    public String getFirstCubeName(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        List cubes = this.definition.getCubes();
        if (cubes.size() > 0) {
            return ((IOlapBuilderCubeDef)cubes.get(0)).getName();
        }
        return null;
    }

    public List<IOlapBuilderCubeDef> getSortedCubes(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        ArrayList<IOlapBuilderCubeDef> cubes = new ArrayList<IOlapBuilderCubeDef>(this.definition.getCubes());
        cubes.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return cubes;
    }

    public IOlapBuilderCubeDef getExistingCube(UxBuilderSchemaLock lock, UxBuilderCubeUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        IOlapBuilderCubeDef cube = this.getCube(lock, name);
        if (cube == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"cube", name.asString()}));
        }
        return cube;
    }

    @Nullable
    public IOlapBuilderCubeDef getCube(UxBuilderSchemaLock lock, UxBuilderCubeUniqueName name) {
        return this.getCubeByUUID(lock, name.asUUID());
    }

    @Nullable
    public IOlapBuilderCubeDef getCubeByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        List cubes = this.definition.getCubes();
        if (cubes != null) {
            for (IOlapBuilderCubeDef cube : cubes) {
                if (!cube.getId().equals(uuid)) continue;
                return cube;
            }
        }
        return null;
    }

    public IOlapBuilderCubeDef getExistingCubeByName(UxBuilderSchemaLock lock, String name) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        IOlapBuilderCubeDef cube = this.getCubeByName(lock, name);
        if (cube == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"cube", name}));
        }
        return cube;
    }

    @Nullable
    public IOlapBuilderCubeDef getCubeByName(UxBuilderSchemaLock lock, String name) {
        lock.assertForReadAccess(this);
        return this.definition.getCube(name);
    }

    public void insertCube(UxBuilderSchemaLock lock, IOlapBuilderCubeDef cube) {
        lock.assertForWriteAccess(this);
        if (this.definition.getCube(cube.getName()) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_NAME_DUPLICATED, new Serializable[]{cube.getName()});
        }
        this.definition.addCube(cube);
    }

    public IOlapBuilderCubeDef renameCube(UxBuilderSchemaLock lock, UxBuilderCubeUniqueName name, String newName) {
        lock.assertForWriteAccess(this);
        IOlapBuilderCubeDef cube = this.getCube(lock, name);
        if (cube == null) {
            throw new RuntimeException("missing cube [" + name.asString() + "]");
        }
        cube.setName(newName);
        return cube;
    }

    public void deleteCube(UxBuilderSchemaLock lock, UxBuilderCubeUniqueName name) {
        lock.assertForWriteAccess(this);
        IOlapBuilderCubeDef cube = this.getCube(lock, name);
        if (cube != null) {
            this.definition.removeCube(cube);
        }
    }

    @Nullable
    public UxBuilderMeasureGroupReference getMeasureGroup(UxBuilderSchemaLock lock, UxBuilderMeasureGroupUniqueName name) {
        return this.getMeasureGroupByUUID(lock, name.asUUID());
    }

    @Nullable
    public UxBuilderMeasureGroupReference getMeasureGroupByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        List cubes = this.definition.getCubes();
        if (cubes != null) {
            for (IOlapBuilderCubeDef cube : cubes) {
                List facts = cube.getFacts();
                if (facts == null) continue;
                for (IOlapBuilderBaseFactsDef fact : facts) {
                    if (!fact.getUUID().equals(uuid)) continue;
                    return new UxBuilderMeasureGroupReference(cube, fact);
                }
            }
        }
        return null;
    }

    public UxBuilderMeasureGroupReference getExistingMeasureGroup(UxBuilderSchemaLock lock, UxBuilderMeasureGroupUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        UxBuilderMeasureGroupReference measureGroup = this.getMeasureGroup(lock, name);
        if (measureGroup == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"measure group", name.toString()}));
        }
        return measureGroup;
    }

    public UxBuilderMeasureGroupReference renameMeasureGroup(UxBuilderSchemaLock lock, UxBuilderMeasureGroupUniqueName name, String newName) {
        lock.assertForWriteAccess(this);
        UxBuilderMeasureGroupReference measureGroup = this.getMeasureGroup(lock, name);
        if (measureGroup == null) {
            throw new RuntimeException("missing measure group [" + String.valueOf(name) + "]");
        }
        OlapBuilderCube cubeR = (OlapBuilderCube)measureGroup.cube;
        if (cubeR.getFacts(newName) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACTS_NAME_DUPLICATED, new Serializable[]{newName});
        }
        measureGroup.measureGroup.setMeasureGroupName(newName);
        return measureGroup;
    }

    public void insertMeasureGroups(UxBuilderSchemaLock lock, List<OlapBuilderFacts> facts) {
        lock.assertForWriteAccess(this);
        for (OlapBuilderFacts fact : facts) {
            IOlapBuilderBaseFactsDef fct;
            if (CdStringUtils.isNullOrBlank((String)fact.getName())) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FIELD_IS_EMPTY, new Serializable[]{"Facts-Name:" + fact.getName()});
            }
            if (CdStringUtils.isNullOrBlank((String)fact.getDataTableId())) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FIELD_IS_EMPTY, new Serializable[]{"Facts-TableId :" + fact.getName()});
            }
            if (fact.getMeasures().isEmpty()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_FACT_MEASURE_MANDATORY, new Serializable[]{fact.getName()});
            }
            IOlapBuilderCubeDef cube = this.getCubeDef(fact.getCubeName());
            if (cube == null || (fct = cube.getFacts(fact.getMeasureGroupName())) == null || fct.getDataView().getId().equals(fact.getDataTableId())) continue;
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_FACT_MEASURE_GROUP_DUPLICATED, new Serializable[]{fact.getName()});
        }
        for (OlapBuilderFacts fact : facts) {
            String cubeName = fact.getCubeName();
            IOlapBuilderCubeDef cube = this.getCubeDef(cubeName);
            if (cube == null) {
                cube = CdStringUtils.isNullOrBlank((String)cubeName) ? new OlapBuilderCube("Cube", (IOlapBuilderBaseFactsDef)fact) : new OlapBuilderCube(cubeName, (IOlapBuilderBaseFactsDef)fact);
                this.definition.addCube(cube);
                continue;
            }
            IOlapBuilderBaseFactsDef existingFacts = cube.getFacts(fact.getMeasureGroupName());
            if (existingFacts == null) {
                cube.addFact(fact);
                continue;
            }
            fact.getMeasures().forEach(arg_0 -> ((IOlapBuilderBaseFactsDef)existingFacts).addOrUpdateMeasureForUx(arg_0));
        }
    }

    @Nullable
    private IOlapBuilderCubeDef getCubeDef(@Nullable String cubeName) {
        IOlapBuilderCubeDef cube = this.definition.getCube(cubeName);
        if (cube == null && CdStringUtils.isNullOrBlank((String)cubeName)) {
            cube = (IOlapBuilderCubeDef)CdCollections.first((List)this.definition.getCubes());
        }
        return cube;
    }

    public UxBuilderMeasureGroupReference insertMeasureGroup(UxBuilderSchemaLock lock, IOlapBuilderBaseFactsDef measureGroup) {
        lock.assertForWriteAccess(this);
        String cubeName = measureGroup.getCubeName();
        IOlapBuilderCubeDef cube = this.getCubeByName(lock, cubeName);
        if (cube != null) {
            OlapBuilderCube cubeR = (OlapBuilderCube)cube;
            if (cubeR.getFacts(measureGroup.getMeasureGroupName()) != null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACTS_NAME_DUPLICATED, new Serializable[]{measureGroup.getMeasureGroupName()});
            }
            cubeR.addFacts(measureGroup);
        } else {
            cube = new OlapBuilderCube(cubeName, measureGroup);
            this.insertCube(lock, cube);
        }
        return new UxBuilderMeasureGroupReference(cube, measureGroup);
    }

    @Nullable
    public UxBuilderMeasureGroupReference moveMeasureGroup(UxBuilderSchemaLock lock, UxBuilderMeasureGroupUniqueName name, String cubeName, String newCubeName) {
        lock.assertForWriteAccess(this);
        if (newCubeName.equalsIgnoreCase(cubeName)) {
            return null;
        }
        UxBuilderMeasureGroupReference measureGroup = this.getMeasureGroup(lock, name);
        if (measureGroup == null) {
            throw new RuntimeException("missing measure group [" + String.valueOf(name) + "]");
        }
        if (!measureGroup.getCubeName().equals(cubeName)) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NAME_MISMATCH, (Serializable[])new Serializable[]{"measure group cube", measureGroup.getCubeName(), cubeName}));
        }
        IOlapBuilderCubeDef fromCube = this.getCubeByName(lock, cubeName);
        if (fromCube == null) {
            throw new RuntimeException("missing cube [" + cubeName + "]");
        }
        IOlapBuilderCubeDef toCube = this.getCubeByName(lock, newCubeName);
        if (toCube == null) {
            toCube = new OlapBuilderCube(newCubeName, measureGroup.measureGroup);
            this.insertCube(lock, toCube);
        } else {
            ((OlapBuilderCube)toCube).addFacts(measureGroup.measureGroup);
        }
        ((OlapBuilderCube)fromCube).removeFacts(measureGroup.measureGroup);
        return new UxBuilderMeasureGroupReference(toCube, measureGroup.measureGroup);
    }

    public void deleteMeasureGroup(UxBuilderSchemaLock lock, UxBuilderMeasureGroupUniqueName name) {
        lock.assertForWriteAccess(this);
        UxBuilderMeasureGroupReference measureGroup = this.getMeasureGroup(lock, name);
        if (measureGroup != null && measureGroup.cube instanceof OlapBuilderCube) {
            OlapBuilderCube cube = (OlapBuilderCube)measureGroup.cube;
            cube.removeFacts(measureGroup.measureGroup);
        }
    }

    public UxBuilderMeasureReference getExistingMeasure(UxBuilderSchemaLock lock, UxBuilderMeasureUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        UxBuilderMeasureReference measure = this.getMeasure(lock, name);
        if (measure == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"measure", name.toString()}));
        }
        return measure;
    }

    @Nullable
    public UxBuilderMeasureReference getMeasure(UxBuilderSchemaLock lock, UxBuilderMeasureUniqueName name) {
        return this.getMeasureByUUID(lock, name.asUUID());
    }

    @Nullable
    public UxBuilderMeasureReference getMeasureByUUID(UxBuilderSchemaLock lock, String uuid) {
        lock.assertForReadAccess(this);
        List cubes = this.definition.getCubes();
        if (cubes != null) {
            for (IOlapBuilderCubeDef cube : cubes) {
                List facts = cube.getFacts();
                if (facts == null) continue;
                for (IOlapBuilderBaseFactsDef fact : facts) {
                    IOlapBuilderMeasureDef measure = fact.getDefinedMeasureByUUID(uuid);
                    if (measure == null) continue;
                    return new UxBuilderMeasureReference(cube, fact, measure);
                }
            }
        }
        return null;
    }

    public UxBuilderMeasureReference renameMeasure(UxBuilderSchemaLock lock, UxBuilderMeasureUniqueName name, String newName) {
        lock.assertForWriteAccess(this);
        UxBuilderMeasureReference existingMeasureRef = this.getExistingMeasure(lock, name);
        IOlapBuilderMeasureDef existingMeasure = existingMeasureRef.measure;
        IOlapBuilderMeasureDef measureWithNewName = existingMeasureRef.measureGroup.getDefinedMeasure(newName);
        if (measureWithNewName != null && !measureWithNewName.equals((Object)existingMeasure)) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_MEASURE_NAME_DUPLICATED, new Serializable[]{newName});
        }
        existingMeasure.setName(newName);
        return existingMeasureRef;
    }

    public void deleteMeasure(UxBuilderSchemaLock lock, UxBuilderMeasureUniqueName name) throws UxBuilderSchemaServiceException {
        lock.assertForWriteAccess(this);
        UxBuilderMeasureReference measure = this.getExistingMeasure(lock, name);
        measure.measureGroup.removeMeasureForUX(measure.measure);
    }

    public List<IOlapBuilderPerspectiveDef> getSortedPerspectives(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        ArrayList<IOlapBuilderPerspectiveDef> perspectives = new ArrayList<IOlapBuilderPerspectiveDef>(this.definition.getPerspectives());
        perspectives.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return perspectives;
    }

    public Set<String> getDimensionNames(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition.getDimensions().stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.toSet());
    }

    @Nullable
    public IOlapBuilderPerspectiveDef getPerspective(UxBuilderSchemaLock lock, String name) {
        lock.assertForReadAccess(this);
        return this.definition.getPerspective(name);
    }

    public void insertPerspective(UxBuilderSchemaLock lock, IOlapBuilderPerspectiveDef perspective) {
        lock.assertForWriteAccess(this);
        if (this.definition.getPerspective(perspective.getName()) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.PERSPECTIVE_NAME_DUPLICATED, new Serializable[]{perspective.getName()});
        }
        this.definition.addPerspective(perspective);
    }

    public IOlapBuilderPerspectiveDef renamePerspective(UxBuilderSchemaLock lock, String name, String newName) {
        lock.assertForWriteAccess(this);
        IOlapBuilderPerspectiveDef perspective = this.getPerspective(lock, name);
        if (perspective == null) {
            throw new RuntimeException("missing perspective [" + name + "]");
        }
        if (this.definition.getPerspective(newName) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.PERSPECTIVE_NAME_DUPLICATED, new Serializable[]{newName});
        }
        perspective.setName(newName);
        return perspective;
    }

    public void deletePerspective(UxBuilderSchemaLock lock, String name) {
        lock.assertForWriteAccess(this);
        IOlapBuilderPerspectiveDef perspective = this.getPerspective(lock, name);
        if (perspective != null) {
            this.definition.removePerspective(perspective);
        }
    }

    public OlapBuilderScript getScript(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition.getScript();
    }

    public void setScript(UxBuilderSchemaLock lock, OlapBuilderScript script, boolean calcMeasuresMigrated) {
        lock.assertForWriteAccess(this);
        this.definition.setScript(script, calcMeasuresMigrated);
    }

    public IOlapBuilderLocalizationDef getLocalization(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition.getLocalization();
    }

    public void setLocalization(UxBuilderSchemaLock lock, IOlapBuilderLocalizationDef localization) {
        lock.assertForWriteAccess(this);
        this.definition.setLocalization(localization);
    }

    public IOlapBuilderColorsDef getColors(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        return this.definition.getColors();
    }

    public void setColors(UxBuilderSchemaLock lock, IOlapBuilderColorsDef colors) {
        lock.assertForWriteAccess(this);
        this.definition.setColors(colors);
    }

    public void switchDataSource(UxBuilderSchemaLock lock, IOlapBuilderDataSource fromDS, IOlapBuilderDataSource toDS) {
        lock.assertForWriteAccess(this);
        fromDS.moveAllTablesTo(toDS);
    }

    public UxSchemaInfoR getSchemaInfoR(UxBuilderSchemaLock lock, UxQueryContext queryContext) {
        return new UxSchemaInfoR(this, queryContext, lock);
    }

    public IOlapBuilderDataColumnDef getColumnDef(UxBuilderSchemaLock lock, String tableOrViewId, String columnName) {
        lock.assertForReadAccess(this);
        return this.definition.getColumnDef(tableOrViewId, columnName);
    }

    public IOlapBuilderTabularDataDef getExistingTabularDataByUUID(UxBuilderSchemaLock lock, String uuid) throws UxBuilderSchemaServiceException {
        lock.assertForReadAccess(this);
        Object data = null;
        UxBuilderTableReference table = this.getDataTableByUUID(lock, uuid);
        data = table != null ? table.table : this.getDataViewByUUID(lock, uuid);
        if (data == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"view", uuid}));
        }
        return data;
    }

    public List<String> getHierarchiesWithoutAll(UxBuilderSchemaLock lock) {
        lock.assertForReadAccess(this);
        ArrayList<String> infos = new ArrayList<String>();
        List dimensions = this.definition.getDimensions();
        for (IOlapBuilderDimensionDef dimension : dimensions) {
            List hierarchies = dimension.getHierarchies();
            for (IOlapBuilderHierarchyDef hierarchy : hierarchies) {
                if (!(hierarchy instanceof OlapBuilderBaseWithAllHierarchy)) continue;
                OlapBuilderBaseWithAllHierarchy hier = (OlapBuilderBaseWithAllHierarchy)hierarchy;
                if (!hier.hasAll()) {
                    infos.add(dimension.getName() + "." + hier.getName());
                    continue;
                }
                if (!CdStringUtils.isNotNullAndNotBlank((String)hier.getDefaultMemberName())) continue;
                infos.add(dimension.getName() + "." + hier.getName());
            }
        }
        return infos;
    }

    public void deleteAllDimensions(UxBuilderSchemaLock lock) {
        lock.assertForWriteAccess(this);
        this.definition.removeAllDimensions();
    }

    public void deleteAllTables(UxBuilderSchemaLock lock, String dataSource) {
        lock.assertForWriteAccess(this);
        IOlapBuilderDataSource ds = this.definition.getDataSource(dataSource);
        if (ds != null) {
            ds.removeAllTable();
        }
    }

    private static /* synthetic */ CdMutableInt lambda$tabularNameUsage$3(String k) {
        return new CdMutableInt(0);
    }

    private static /* synthetic */ CdMutableInt lambda$tabularNameUsage$1(String k) {
        return new CdMutableInt(0);
    }
}

