/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.common;

import crazydev.common.utils.CdStringUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxSchemaId {
    @Nullable
    public String schemaName;
    @Nullable
    public String schemaFile;

    public UxSchemaId(@Nullable String schemaName, @Nullable String schemaFile) {
        this.schemaName = schemaName;
        this.schemaFile = schemaFile;
        if (CdStringUtils.isNullOrBlank((String)schemaName) && CdStringUtils.isNullOrBlank((String)schemaFile)) {
            throw new RuntimeException("internal error: missing schemaName|schemaFile [" + schemaName + "][" + schemaFile + "]");
        }
    }

    public String asUseCaseAdditionalInfo() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.schemaName) ? this.schemaName : this.schemaFile;
    }

    public String asErrorInfo() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.schemaName) ? this.schemaName : this.schemaFile;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UxSchemaId that = (UxSchemaId)other;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.schemaFile, that.schemaFile);
    }

    public String toString() {
        return "[" + this.schemaName + "][" + this.schemaFile + "]";
    }
}

