/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.common;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.model.UxExtraNavigationKeyId;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxAbstractLazyTreeNode<NODE_ID, NODE extends UxAbstractLazyTreeNode<NODE_ID, NODE>>
implements UxSerializable {
    private final NODE_ID nodeId;
    private final String keyId;
    private final String caption;
    @Nullable
    private final String tooltip;
    @Nullable
    private final Boolean file;
    @Nullable
    private final List<NODE> children;
    @Nullable
    private final Boolean isMoreItem;

    public UxAbstractLazyTreeNode(NODE_ID nodeId, String caption, @Nullable String tooltip, boolean file, @Nullable List<NODE> children, boolean isMoreItem) {
        this.keyId = UxExtraNavigationKeyId.create(nodeId, isMoreItem);
        this.caption = caption;
        this.tooltip = !isMoreItem ? tooltip : null;
        this.children = children;
        this.file = !file ? null : Boolean.valueOf(true);
        Boolean bl = this.isMoreItem = !isMoreItem ? null : Boolean.valueOf(true);
        if (this.children == null || this.isKeepNodeId()) {
            this.nodeId = nodeId;
        } else {
            boolean hasMore = false;
            int ii = children.size();
            while (ii-- > 0) {
                UxAbstractLazyTreeNode child = (UxAbstractLazyTreeNode)children.get(ii);
                if (!child.isMoreItem()) continue;
                hasMore = true;
                break;
            }
            this.nodeId = hasMore ? nodeId : null;
        }
    }

    protected abstract boolean isKeepNodeId();

    public NODE_ID getNodeId() {
        return this.nodeId;
    }

    public String getCaption() {
        return this.caption;
    }

    public boolean isMoreItem() {
        return this.isMoreItem != null && this.isMoreItem != false;
    }

    public String toString() {
        return this.caption;
    }
}

