/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.code.queries.provider;

import crazydev.iccube.ux.builder.code.queries.UxCodeCompletion;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionKind;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionProvider;
import crazydev.iccube.ux.builder.code.queries.UxCodeSuggestion;
import crazydev.iccube.ux.common.query.UxQueryContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UxCodeCompletionJavascript
extends UxCodeCompletionProvider {
    private static String[] javaView = new String[0];
    private static String[] javaViewEmpty = new String[]{"arr()", "arr_add(arr,val)", "arr_contains(val)", "arr_get(arr,idx)", "arr_len(arr)", "arr_push(arr,val)", "copy()", "create()", "ctxt.", "debug(msg)", "error(msg)", "get(\"col\")", "get(row,\"col\")", "fire()", "fire(rowNumber)", "fire(row,rowNumber)", "isDebugEnabled", "is_arr(val)", "set(\"col\",val)", "newDate()", "newDate(year,month,dayOfMonth)", "newDateTime()", "newDateTime(year,month,dayOfMonth,hour,min,sec)", "setIfNull(\"col\",val)", "set(row,\"col\",val)", "table_name()", "warn(msg)"};
    private static List<Character> wordSeparator = Arrays.asList(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf(';'), Character.valueOf('}'), Character.valueOf('{'));
    private final String[] viewCodeCompl = javaView;
    private final String[] emptyCompletion = javaViewEmpty;

    public UxCodeCompletionJavascript(UxCodeCompletionKind completionKind, int maxCount, String code, int offset) {
        super(completionKind, maxCount, code, offset);
    }

    @Override
    public UxCodeCompletion complete(UxQueryContext context) {
        String toScan;
        ArrayList<UxCodeSuggestion> suggestions = new ArrayList<UxCodeSuggestion>();
        if (this.offset < 0 || this.offset > this.code.length()) {
            return new UxCodeCompletion(suggestions);
        }
        int startPos = 0;
        for (int i = this.offset - 1; i >= 0; --i) {
            if (!wordSeparator.contains(Character.valueOf(this.code.charAt(i)))) continue;
            startPos = i + 1;
            break;
        }
        if ((toScan = this.code.substring(startPos, this.offset)).trim().length() == 0) {
            for (int i = 0; i < this.emptyCompletion.length; ++i) {
                String item = this.emptyCompletion[i];
                suggestions.add(new UxCodeSuggestion(item, item));
            }
            return new UxCodeCompletion(suggestions);
        }
        this.getSuggestions(suggestions, toScan);
        return new UxCodeCompletion(suggestions);
    }

    private void getSuggestions(List<UxCodeSuggestion> suggestions, String toScan) {
        String upperQuery = toScan.toUpperCase();
        for (int i = 0; i < this.viewCodeCompl.length; ++i) {
            String code = this.viewCodeCompl[i];
            if (!code.toUpperCase().startsWith(upperQuery)) continue;
            suggestions.add(new UxCodeSuggestion(code.substring(upperQuery.length()), code));
        }
    }

    static {
        Arrays.sort(javaView);
        Arrays.sort(javaViewEmpty);
    }
}

