/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.code.queries.provider;

import crazydev.iccube.ux.builder.code.queries.UxCodeCompletion;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionKind;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionProvider;
import crazydev.iccube.ux.builder.code.queries.UxCodeSuggestion;
import crazydev.iccube.ux.common.query.UxQueryContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UxCodeCompletionColumnDefs
extends UxCodeCompletionProvider {
    static final List<String> COL_TYPES = new ArrayList<String>(Arrays.asList("BOOLEAN", "DATE", "DATETIME", "DOUBLE", "INTEGER", "FLOAT", "JAVA_OBJECT", "LONG", "SHORT", "STRING", "UPPERCASE_STRING"));
    static final List<String> COL_DECORATIONS = new ArrayList<String>(Arrays.asList("ARRAY"));

    public UxCodeCompletionColumnDefs(UxCodeCompletionKind completionKind, int maxCount, String code, int offset) {
        super(completionKind, maxCount, code, offset);
    }

    @Override
    public UxCodeCompletion complete(UxQueryContext context) {
        ArrayList<UxCodeSuggestion> suggestions = new ArrayList<UxCodeSuggestion>();
        if (this.offset < 0 || this.offset > this.code.length()) {
            return new UxCodeCompletion(suggestions);
        }
        String toScan = this.code.substring(0, this.offset);
        if (toScan.trim().length() == 0) {
            return new UxCodeCompletion(suggestions);
        }
        this.getSuggestions(suggestions, toScan);
        return new UxCodeCompletion(suggestions);
    }

    private void getSuggestions(List<UxCodeSuggestion> suggestions, String toScan) {
        int ii;
        int sepCount = 0;
        for (ii = toScan.length() - 1; ii > -1; --ii) {
            char cc = toScan.charAt(ii);
            if (cc == ':') {
                ++sepCount;
            }
            if (cc == '\n' || cc == '\r') break;
        }
        if (ii > toScan.length() - 1) {
            return;
        }
        String lastLine = toScan.substring(ii + 1).trim();
        String[] tokens = lastLine.split(":");
        if (sepCount == 1 && tokens.length == 2) {
            this.getSuggestions(suggestions, COL_TYPES, tokens[tokens.length - 1]);
        } else if (sepCount == 2 && tokens.length == 3) {
            this.getSuggestions(suggestions, COL_DECORATIONS, tokens[tokens.length - 1]);
        } else if (sepCount == 1) {
            this.getSuggestions(suggestions, COL_TYPES, "");
        } else if (sepCount == 2) {
            this.getSuggestions(suggestions, COL_DECORATIONS, "");
        }
    }

    private void getSuggestions(List<UxCodeSuggestion> suggestions, List<String> allTokens, String tokenStart) {
        tokenStart = tokenStart.trim();
        for (String token : allTokens) {
            if (tokenStart.length() != 0 && !token.startsWith(tokenStart)) continue;
            suggestions.add(new UxCodeSuggestion(token.substring(tokenStart.length()), token));
        }
    }
}

