/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.errors.OlapBuilderErrorsException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.ux.meta.UxBuilderMetaInfo;
import crazydev.iccube.builder.ux.meta.common.model.UxModelPropertyFilter;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateDataTableWizard;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderDataSourceTableNamesForm;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.UxResultDockType;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.model.UxExtraNavigationTree;
import crazydev.iccube.ux.builder.queries.datatable.analyse.UxTableAnalyseExQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTableBrowseExQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.create.discover.UxDiscoverDataTablesQueryMeta;
import crazydev.iccube.ux.builder.queries.revisions.UxSchemaDefRevisionsQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefStep;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefValidation;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionUtils;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.field.UxHelpText;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.reply.payload.UxReplyPayloadWarning;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationSynopsis;
import crazydev.iccube.ux.console.queries.init.UxConsoleInitDataQuery;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxSchemaBuilderQuery
extends UxBuilderQuery {
    protected final UxSchemaId schemaId;

    protected UxSchemaBuilderQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId);
        this.schemaId = schemaId;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        queryContext.setupPersistentSchema(this.schemaId);
        try {
            UxReply reply = this.executeQueryForPersistentSchema(queryContext);
            return reply;
        }
        catch (UxBuilderSchemaServiceException expected) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] service error", (Throwable)expected);
            return UxReply.error(queryContext, expected.error());
        }
        catch (OlapBuilderErrorsException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] builder error(s)", (Throwable)ex);
            return UxReply.validationErrors(UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), ex.getErrors()));
        }
        catch (OlapBuilderErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] builder error", (Throwable)ex);
            return UxReply.validationErrors(UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)ex.getError()));
        }
    }

    @Override
    protected void attachUseCaseAdditionalInfo(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCaseAdditionalInfo(this.schemaId.asUseCaseAdditionalInfo());
    }

    @Override
    protected void attachUseCases(UxQueryContext queryContext, UxPayloadReply reply) {
        UxUseCase currentUseCase = reply.currentUseCase();
        UxExtraNavigationTree extraNavigation = null;
        if (currentUseCase != null) {
            block5: {
                try {
                    extraNavigation = currentUseCase.setupExtraNavigation(queryContext, this.schemaId, reply.isCurrentUseCaseWithSemanticLayerExtraNavigation(), reply.isCurrentUseCaseWithMeasuresExtraNavigation());
                }
                catch (RuntimeException useCaseEX) {
                    OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] extra navigation setup [" + currentUseCase.id() + "] error"), (Throwable)useCaseEX);
                    UxBabylonService babylon = queryContext.getUxBabylonService();
                    String information = babylon.translate("builder.extraNavigationSetupError", new Serializable[]{currentUseCase.caption()});
                    UxUseCase revisions = null;
                    try {
                        revisions = UxSchemaDefRevisionsQueryMeta.createUseCase(queryContext, this.schemaId, false);
                    }
                    catch (RuntimeException revisionsEX) {
                        OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] revisions use-case setup error [" + currentUseCase.id() + "] error"), (Throwable)revisionsEX);
                    }
                    if (reply.isForSchemaDefRevisions()) break block5;
                    reply.withWarning(new UxReplyPayloadWarning(information, revisions));
                }
            }
            List<UxUseCase> useCases = UxConsoleInitDataQuery.setupBuilderUseCases(queryContext, this.schemaId);
            reply.withUseCases(null, useCases, extraNavigation);
        }
    }

    @Override
    protected void attachApps(UxQueryContext queryContext, UxPayloadReply reply) {
        if (reply.hasUseCase()) {
            reply.withApps(UxConsoleInitDataQuery.setupApps(queryContext, UxAppType.builder));
        }
    }

    protected static IOlapBuilderDataTableDef createDiscoveredTable(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, String dataSourceName, String tableName) {
        IOlapBuilderDataSource dataSource = schema.getExistingDataSource(lock, dataSourceName);
        OlapBuilderBaseDataTable table = dataSource.createEmptyDiscoverTable(tableName);
        table.setDataSource(dataSource);
        UxSchemaBuilderQuery.discoverAndSelectAllColumns(context.asRuntimeContext(), dataSource, table);
        return table;
    }

    protected static IOlapBuilderTabularDataDef getTabularData(UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable UxBuilderTablePathName tableName, @Nullable String viewName) {
        IOlapBuilderDataViewDef data;
        if (tableName != null) {
            UxBuilderTableReference table = schema.getDataTable(lock, tableName);
            if (table != null) {
                table.table.setDataSource(table.dataSource);
                data = table.table;
            } else {
                data = null;
            }
        } else {
            data = schema.getDataViewByName(lock, viewName);
        }
        return data;
    }

    protected static UxReply replyTabularDataNotFound(UxQueryContext context, @Nullable UxBuilderTablePathName tableName, @Nullable String viewName) {
        if (tableName != null) {
            return UxReply.error(context, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND_EX, (Serializable[])new Serializable[]{"table", tableName.getTableName()}));
        }
        if (viewName != null) {
            return UxReply.error(context, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND_EX, (Serializable[])new Serializable[]{"view", viewName}));
        }
        return UxReply.error(context, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND_EX, (Serializable[])new Serializable[]{"table|view", "<null>"}));
    }

    protected void setModelTypesSetupInfoForDataTable(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, boolean nameWRITE) {
        context.setModelTypeSetupInfo(question -> {
            if (question.equals("NAME_WRITE")) {
                return nameWRITE;
            }
            if (question.equals("INCR_LOAD")) {
                return schema.incrLoadActive(lock);
            }
            if (question.equals("PARTITIONING")) {
                return schema.useFactPartitioning(lock);
            }
            return false;
        });
    }

    protected void setModelTypesSetupInfoForDataView(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, boolean nameWRITE) {
        context.setModelTypeSetupInfo(question -> {
            if (question.equals("NAME_WRITE")) {
                return nameWRITE;
            }
            return false;
        });
    }

    protected UxWizardDefStep setupWizardStepUI(UxQueryContext context, UxBuilderWizardStep step) {
        return this.setupWizardStepUI(context, null, null, step);
    }

    protected UxWizardDefStep setupWizardStepUI(UxQueryContext context, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, UxBuilderWizardStep step) {
        UxBabylonService babylon = context.getUxBabylonService();
        String id = step.getId();
        String caption = babylon.translate(id, new Serializable[0]);
        UxHelpText description = babylon.translateWizardDescription(step.getActualDescriptionTag());
        boolean optional = step.isOptional();
        boolean validate = step.isValidate();
        boolean autoNext = step.isAutoNext();
        boolean modelHideFieldName = step.isModelHideFieldName();
        boolean modelFullWidth = step.isModelFullWidth();
        Object model = step.getModel();
        UxModelPropertyFilter modelProps = step.getModelProps();
        UxModel modelUI = model != null ? context.convertToUxModel(-1, lock, parentServerModel, model, modelProps, null) : null;
        List<UxAction> actions = new ArrayList<UxAction>();
        if (step.getId().equals("wizard.createDataTable.discoverTables")) {
            String dataSourceName = ((UxBuilderDataSourceTableNamesForm)model).getDataSourceName();
            UxAction discoverTables = UxDiscoverDataTablesQueryMeta.createAction(context, this.schemaId, dataSourceName);
            UxAction analyseTable = UxTableAnalyseExQueryMeta.createAction(context, this.schemaId, dataSourceName);
            UxAction browseTable = UxTableBrowseExQueryMeta.createAction(context, this.schemaId, dataSourceName);
            actions = UxActionUtils.addActions(actions, discoverTables, analyseTable, browseTable);
        }
        return new UxWizardDefStep(id, caption, description, optional, validate, autoNext, modelHideFieldName, modelFullWidth, modelUI, modelProps, actions);
    }

    protected UxWizardDefValidation setupWizardValidationUI(UxQueryContext context, UxBuilderWizardValidation validation) {
        return this.setupWizardValidationUI(context, null, null, validation);
    }

    protected UxWizardDefValidation setupWizardValidationUI(UxQueryContext context, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, UxBuilderWizardValidation validation) {
        ArrayList<UxWizardDefStep> stepsUI = new ArrayList<UxWizardDefStep>();
        List steps = validation.getSteps();
        if (steps != null) {
            for (UxBuilderWizardStep step : steps) {
                stepsUI.add(this.setupWizardStepUI(context, lock, parentServerModel, step));
            }
        }
        String useCaseTitle = validation.getUseCaseTitle();
        return new UxWizardDefValidation(validation.getActiveStep(), stepsUI, useCaseTitle);
    }

    protected UxBuilderDataSourceType setupCreateDataSourceWizardTypeFromUI(UxQueryContext context, UxBuilderCreateDataSourceWizard wizard) {
        String dataSourceTypeName = wizard.getDataSourceTypeName();
        if (dataSourceTypeName == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_WIZARD_ERROR, (Serializable[])new Serializable[]{"missing data source type"}));
        }
        UxBuilderMetaInfo meta = context.getBuilderMetaInfo();
        UxBuilderDataSourceType dataSourceType = meta.getDataSourceType(dataSourceTypeName);
        if (dataSourceType == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_WIZARD_ERROR, (Serializable[])new Serializable[]{"unknown data source type [" + dataSourceTypeName + "]"}));
        }
        return dataSourceType;
    }

    protected UxBuilderCreateTypedDataSourceWizard setupCreateDataSourceTypedWizardFromUI(UxQueryContext context, UxBuilderCreateDataSourceWizard wizard) {
        UxBuilderDataSourceType dsType = this.setupCreateDataSourceWizardTypeFromUI(context, wizard);
        UxBuilderCreateTypedDataSourceWizard typedWizard = dsType.createTypedWizard();
        List typedWizardSteps = wizard.getTypedWizardSteps();
        typedWizard.setSteps(typedWizardSteps);
        return typedWizard;
    }

    protected IOlapBuilderDataSource setupCreateDataTableWizardDataSourceFromUI(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, UxBuilderCreateDataTableWizard wizard) {
        String dataSourceName = wizard.getDataSourceName();
        if (dataSourceName == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_WIZARD_ERROR, (Serializable[])new Serializable[]{"missing data source name"}));
        }
        IOlapBuilderDataSource dataSource = schema.getExistingDataSource(lock, dataSourceName);
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void discoverAndSelectAllColumns(OlapRuntimeContext context, IOlapBuilderDataSource dataSource, OlapBuilderBaseDataTable dataTable) {
        try (IOlapBuilderConnection connection = dataSource.createConnection(context, false);){
            connection.open(context);
            OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
            UxSchemaBuilderQuery.discoverAndSelectAllColumns(context, errorManager, connection, dataSource, dataTable);
        }
    }

    protected static void discoverAndSelectAllColumns(OlapRuntimeContext context, OlapBuilderErrorManager errorManager, IOlapBuilderConnection connection, IOlapBuilderDataSource dataSource, OlapBuilderBaseDataTable dataTable) {
        dataTable.setDataSource(dataSource);
        dataTable.clearColumns();
        List columns = dataTable.discoverAllColumns(context, connection, errorManager);
        for (IOlapBuilderDataColumnDef column : columns) {
            if (column.getType() == OlapBuilderInputType.DB_TYPE_UNSUPPORTED) {
                column.setSelected(false);
            }
            dataTable.addColumn(column);
        }
    }

    protected void setModelTypesSetupInfoForMeasureGroup(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, boolean nameWRITE, boolean nameWRITEc, boolean measureFast) {
        context.setModelTypeSetupInfo(question -> {
            if (question.equals("NAME_WRITE")) {
                return nameWRITE;
            }
            if (question.equals("NAME_WRITEc")) {
                return nameWRITEc;
            }
            if (question.equals("MEASURE_FAST")) {
                return measureFast;
            }
            return false;
        });
    }

    protected static void solveViewsForFactsMappings(UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        schema.forEachView(lock, view -> OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)false, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)view));
    }

    protected static UxValidationSynopsis createSynopsisForValidation(UxQueryContext context, UxBuilderSchema schema) {
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translate("schemaValidationCaption", new Serializable[0]);
        String message = babylon.translate("schemaValidationMessage", new Serializable[0]);
        return new UxValidationSynopsis(caption, message);
    }

    protected static UxResultDockName createDockNameForValidation(UxBuilderSchema schema) {
        return new UxResultDockName(UxResultDockType.SCHEMA_VALIDATION, schema.getName(), schema.getName());
    }
}

