/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder;

import crazydev.common.exception.CdError;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorsException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.console.queries.init.UxConsoleInitDataQuery;

public abstract class UxBuilderQuery
extends UxQuery {
    protected UxBuilderQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        try {
            UxReply reply = this.executeQueryForPersistentSchema(queryContext);
            return reply;
        }
        catch (UxBuilderSchemaServiceException expected) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] service error", (Throwable)expected);
            return UxReply.error(queryContext, expected.error());
        }
        catch (OlapBuilderErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] builder error", (Throwable)ex);
            return UxReply.validationErrors(UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)ex.getError()));
        }
        catch (OlapBuilderErrorsException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] builder error(s)", (Throwable)ex);
            return UxReply.validationErrors(UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), ex.getErrors()));
        }
    }

    protected abstract UxReply executeQueryForPersistentSchema(UxQueryContext var1) throws UxBuilderSchemaServiceException;

    @Override
    protected void attachUseCases(UxQueryContext queryContext, UxPayloadReply reply) {
        if (reply.hasUseCase()) {
            reply.withUseCases(null, UxConsoleInitDataQuery.setupBuilderUseCases(queryContext, null), null);
        }
    }

    @Override
    protected void attachApps(UxQueryContext queryContext, UxPayloadReply reply) {
        if (reply.hasUseCase()) {
            reply.withApps(UxConsoleInitDataQuery.setupApps(queryContext, UxAppType.builder));
        }
    }
}

