/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.utils;

import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDocFile;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.ux.common.query.UxQueryContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public interface UxFileWrapper {
    public String getName();

    public String getMimeType();

    default public String getCodeMirrorMode() {
        return this.getMimeType();
    }

    public boolean deleteOnExit();

    public String getAbsolutePath();

    public boolean exists();

    public long length();

    default public int maxLen(UxQueryContext context) {
        IcCubeServerProperties properties = context.getServerProperties();
        int maxLen = properties.getMaxFileSizeForGuiVisualization();
        return maxLen;
    }

    public InputStream createInputStream() throws IOException;

    public Reader createInputStreamReader(InputStream var1);

    public boolean delete();

    public static UxFileWrapper forOlapFile(@Nullable OlapFile file, String path, String mimeType, boolean deleteOnExit) {
        return UxFileWrapper.forOlapFile(file, path, mimeType, mimeType, deleteOnExit);
    }

    public static UxFileWrapper forOlapFile(final @Nullable OlapFile file, final String path, final String mimeType, final String codeMirrorMode, final boolean deleteOnExit) {
        return new UxFileWrapper(){

            @Override
            public String getName() {
                return FilenameUtils.getName((String)path);
            }

            @Override
            public String getMimeType() {
                return mimeType;
            }

            @Override
            public String getCodeMirrorMode() {
                return codeMirrorMode;
            }

            @Override
            public boolean deleteOnExit() {
                return deleteOnExit;
            }

            @Override
            public String getAbsolutePath() {
                return path;
            }

            @Override
            public boolean exists() {
                return file != null && file.exists();
            }

            @Override
            public long length() {
                return file != null ? file.length() : 0L;
            }

            @Override
            public InputStream createInputStream() throws IOException {
                if (file == null) {
                    return null;
                }
                String nameLC = file.getName().toLowerCase();
                if (nameLC.endsWith(".log.gz")) {
                    return new GZIPInputStream(file.createInputStream());
                }
                return file.createInputStream();
            }

            @Override
            public Reader createInputStreamReader(InputStream in) {
                return new InputStreamReader(in, StandardCharsets.UTF_8);
            }

            @Override
            public boolean delete() {
                return file != null && file.delete();
            }
        };
    }

    public static UxFileWrapper forDocsFile(final OlapDocsDocFile file, String path) {
        return new UxFileWrapper(){

            @Override
            public String getName() {
                return file.getFileName();
            }

            @Override
            public String getMimeType() {
                return file.getMimeType();
            }

            @Override
            public boolean deleteOnExit() {
                return false;
            }

            @Override
            public String getAbsolutePath() {
                return file.getFileName();
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public long length() {
                return 0L;
            }

            @Override
            public InputStream createInputStream() throws IOException {
                try {
                    return file.getInputStream();
                }
                catch (OlapDocsErrorException ex) {
                    throw new IOException((Throwable)((Object)ex));
                }
            }

            @Override
            public Reader createInputStreamReader(InputStream in) {
                return new InputStreamReader(in, StandardCharsets.UTF_8);
            }

            @Override
            public boolean delete() {
                return false;
            }
        };
    }

    public static UxFileWrapper forString(String fileName, String content, String mimeType) {
        return UxFileWrapper.forString(fileName, content, mimeType, mimeType);
    }

    public static UxFileWrapper forString(final String fileName, final String content, final String mimeType, final @Nullable String codeMirrorMode) {
        return new UxFileWrapper(){

            @Override
            public String getName() {
                return FilenameUtils.getName((String)fileName);
            }

            @Override
            public String getMimeType() {
                return mimeType;
            }

            @Override
            public String getCodeMirrorMode() {
                return codeMirrorMode;
            }

            @Override
            public boolean deleteOnExit() {
                return false;
            }

            @Override
            public String getAbsolutePath() {
                return fileName;
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public long length() {
                return content.length();
            }

            @Override
            public InputStream createInputStream() {
                return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            public Reader createInputStreamReader(InputStream in) {
                return new InputStreamReader(in, StandardCharsets.UTF_8);
            }

            @Override
            public boolean delete() {
                return false;
            }
        };
    }

    public static UxFileWrapper forBinary(final String fileName, final byte[] content, final String mimeType) {
        return new UxFileWrapper(){

            @Override
            public String getName() {
                return FilenameUtils.getName((String)fileName);
            }

            @Override
            public String getMimeType() {
                return mimeType;
            }

            @Override
            public boolean deleteOnExit() {
                return false;
            }

            @Override
            public String getAbsolutePath() {
                return fileName;
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public long length() {
                return content.length;
            }

            @Override
            public InputStream createInputStream() {
                return new ByteArrayInputStream(content);
            }

            @Override
            public Reader createInputStreamReader(InputStream in) {
                throw new RuntimeException("internal error: input stream reader not supported [" + fileName + "]");
            }

            @Override
            public boolean delete() {
                return false;
            }
        };
    }
}

