/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.users;

import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.users.UxAbstractUserQuery;
import crazydev.iccube.ux.admin.queries.users.UxUserPhotoQueryMeta;
import crazydev.iccube.ux.admin.queries.users.UxUserQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxUsersQuery
extends UxAbstractUserQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxUsersQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "photo", "name", "roles");
        if (queryContext.isWithMultiTenant()) {
            header.add(babylon, "tenant");
        }
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<OlapUserDefinition>("name", babylon.translate("filterUserName", new Serializable[0]), OlapUserDefinition::getName), new UxFilterMeta<OlapUserDefinition>("roles", babylon.translate("filterRoleNames", new Serializable[0]), OlapUserDefinition::getRoleNames));
        if (queryContext.isWithMultiTenant()) {
            filterMetas.add(new UxFilterMeta<OlapUserDefinition>("tenant", babylon.translate("filterTenantName", new Serializable[0]), OlapUserDefinition::getTenant));
        }
        UxTableRowSearcher<OlapUserDefinition> searcher = new UxTableRowSearcher<OlapUserDefinition>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(OlapUserDefinition row, String searchText) {
                return this.isContaining(searchText, row.getName(), row.getRoleNames(), row.getTenant());
            }
        };
        IOlapAuthenticationService service = queryContext.getAuthenticationService();
        List<Object> users = service.isEditable() ? this.filter(this.tableOptions, searcher, filterMetas, service.getSortedUserDefinitions()) : new ArrayList();
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        boolean withMultiTenant = queryContext.isWithMultiTenant();
        int totalRowCount = 0;
        for (OlapUserDefinition olapUserDefinition : users) {
            if (withMultiTenant) {
                OlapTenant tenant = queryContext.asRuntimeContext().getDirectoriesResolved().getTenant();
                String userTenantName = olapUserDefinition.getTenant();
                if (tenant != null && !tenant.getName().equals(userTenantName)) continue;
                rows.add(this.createRow(queryContext, olapUserDefinition));
                ++totalRowCount;
                continue;
            }
            rows.add(this.createRow(queryContext, olapUserDefinition));
            ++totalRowCount;
        }
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "name", UxTableSortType.asc, totalRowCount));
        UxTable uxTable = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, uxTable));
    }

    private UxTableRow createRow(UxQueryContext context, OlapUserDefinition user) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        String usersRevision = context.getUsersRevision();
        String userName = user.getName();
        UxUrl userPhoto = UxUserPhotoQueryMeta.UserPhoto.createQueryUrl(userName, usersRevision);
        cells.add(new UxTableCell(userPhoto.toUrl()).withStyle(UxStylePresentation.AVATAR));
        UxUseCase useCase = UxUserQueryMeta.createUseCase(context, user.getUUID(), user.getName());
        cells.add(new UxTableCell((Object)user.getName(), useCase));
        cells.add(new UxTableCell(user.getRoleNames()));
        if (context.isWithMultiTenant()) {
            cells.add(new UxTableCell(user.getTenant()));
        }
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Users));
    }
}

