/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.users;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.authentication.definition.OlapUserDefinitions;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authentication.IOlapUserDefinitions;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.ux.admin.queries.users.UxUsersException;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public abstract class UxUsersHelper {
    private static final Object LOCK = new Object();

    private UxUsersHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult saveUserDefinition(UxQueryContext context, OlapUserDefinition user, int revNumber) {
        Object object = LOCK;
        synchronized (object) {
            return UxUsersHelper.saveUserDefinitionUnsafe(context, user, revNumber);
        }
    }

    @Nullable
    private static UxValidationResult saveUserDefinitionUnsafe(UxQueryContext context, OlapUserDefinition user, int revNumber) {
        OlapUserDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File xml = new File(directories.getUsersDirectory(), "icCubeUsers.icc-users");
        try {
            definitions = UxUsersHelper.unmarshallUserDefinitions(context, xml);
        }
        catch (UxUsersException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{ex.getMessage()})));
        }
        IOlapAuthenticationService service = context.getAuthenticationService();
        String error = UxUsersHelper.saveOrUpdateUser(context, definitions, service.isUserNameCaseSensitive(), user, revNumber);
        if (error != null) {
            return new UxValidationResult(new UxValidationMessage("ERROR", error));
        }
        try {
            service.refresh((IOlapUserDefinitions)definitions);
        }
        catch (OlapAuthenticationServiceException ex) {
            return UxUsersHelper.onAuthenticationServiceException(context, ex);
        }
        try {
            String operation = "edit user " + user.getName();
            UxUsersHelper.marshallUserDefinitions(context, definitions, operation);
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[users] could not save users definitions (/SaveUser)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{babylon.translate("userDefsError_persist", new Serializable[0])})));
        }
        return null;
    }

    @Nullable
    private static String saveOrUpdateUser(UxQueryContext context, OlapUserDefinitions definitions, boolean userNameCaseSensitive, OlapUserDefinition user, int revNumber) {
        OlapTenant tenant;
        OlapTenant tenant2;
        UxBabylonService babylon = context.getUxBabylonService();
        if (context.isWithMultiTenant() && (tenant2 = context.asRuntimeContext().getDirectoriesResolved().getTenant()) != null && !tenant2.getName().equals(user.getTenant())) {
            return UxErrorCode.USER_INVALID_TENANT.asMessage(babylon, new Serializable[]{tenant2.getName(), user.getTenant()});
        }
        IOlapAuthenticationService service = context.getAuthenticationService();
        int currentRevNumber = service.getRevisionNumber();
        if (currentRevNumber != revNumber) {
            return UxErrorCode.USERS_REV_NUMBER_MISMATCH.asMessage(babylon, new Serializable[]{Integer.valueOf(currentRevNumber), Integer.valueOf(revNumber)});
        }
        if (CdStringUtils.isNullOrBlank((String)user.getUUID())) {
            return UxErrorCode.USER_MISSING_UUID.asMessage(babylon, new Serializable[0]);
        }
        OlapUserDefinition existingUser = UxUsersHelper.getUserDefinitionByUUID(definitions, user.getUUID());
        if (existingUser != null && context.isWithMultiTenant() && (tenant = context.asRuntimeContext().getDirectoriesResolved().getTenant()) != null && !tenant.getName().equals(existingUser.getTenant())) {
            return UxErrorCode.USER_INVALID_TENANT.asMessage(babylon, new Serializable[]{tenant.getName(), existingUser.getTenant()});
        }
        String error = UxUsersHelper.validate(context, existingUser, user);
        if (error != null) {
            return error;
        }
        if (existingUser != null) {
            existingUser.refreshForUX(user);
            return null;
        }
        if (UxUsersHelper.getUserDefinitionByName(definitions, userNameCaseSensitive, user.getName()) != null) {
            return UxErrorCode.USER_DUPLICATED.asMessage(babylon, new Serializable[]{user.getName()});
        }
        definitions.addUserDefinition(user);
        return null;
    }

    @Nullable
    private static String validate(UxQueryContext context, @Nullable OlapUserDefinition existingUser, OlapUserDefinition user) {
        List roles;
        UxBabylonService babylon = context.getUxBabylonService();
        if (CdStringUtils.isNullOrBlank((String)user.getUUID())) {
            return UxErrorCode.USER_MISSING_UUID.asMessage(babylon, new Serializable[0]);
        }
        if (CdStringUtils.isNullOrBlank((String)user.getName())) {
            return UxErrorCode.USER_MISSING_NAME.asMessage(babylon, new Serializable[0]);
        }
        boolean requiredPassword = context.isUserDefinitionWithPassword();
        if (requiredPassword) {
            String password = user.getPassword();
            if (existingUser == null || CdStringUtils.isNotNullAndNotBlank((String)password)) {
                String passwordConfirm = user.getPasswordConfirm();
                if (password == null || CdStringUtils.isNullOrBlank((String)password)) {
                    return UxErrorCode.USER_MISSING_PASSWORD.asMessage(babylon, new Serializable[0]);
                }
                if (passwordConfirm == null || CdStringUtils.isNullOrBlank((String)passwordConfirm)) {
                    return UxErrorCode.USER_MISSING_PASSWORD_CONFIRM.asMessage(babylon, new Serializable[0]);
                }
                if (!password.equals(passwordConfirm)) {
                    return UxErrorCode.USER_PASSWORD_MISMATCH.asMessage(babylon, new Serializable[0]);
                }
                IOlapAuthenticationService service = context.getAuthenticationService();
                int passwordMinLength = service.getPasswordMinLength();
                if (password.length() < passwordMinLength) {
                    return UxErrorCode.USER_PASSWORD_INVALID_LEN.asMessage(babylon, new Serializable[]{Integer.valueOf(passwordMinLength)});
                }
            }
            user.hashPassword();
        }
        if ((roles = user.getRoles()) == null || roles.isEmpty()) {
            return UxErrorCode.USER_MISSING_ROLES.asMessage(babylon, new Serializable[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult deleteUserDefinition(UxQueryContext context, String uuid) {
        Object object = LOCK;
        synchronized (object) {
            return UxUsersHelper.deleteUserDefinitionUnsafe(context, uuid);
        }
    }

    @Nullable
    private static UxValidationResult deleteUserDefinitionUnsafe(UxQueryContext context, String uuid) {
        OlapUserDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File xml = new File(directories.getUsersDirectory(), "icCubeUsers.icc-users");
        try {
            definitions = UxUsersHelper.unmarshallUserDefinitions(context, xml);
        }
        catch (UxUsersException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{ex.getMessage()})));
        }
        OlapUserDefinition status = UxUsersHelper.deleteUser(context, definitions, uuid);
        if (status == null) {
            return null;
        }
        try {
            IOlapAuthenticationService service = context.getAuthenticationService();
            service.refresh((IOlapUserDefinitions)definitions);
        }
        catch (OlapAuthenticationServiceException ex) {
            return UxUsersHelper.onAuthenticationServiceException(context, ex);
        }
        try {
            String operation = "delete user " + (status.getName() != null ? status.getName() : uuid);
            UxUsersHelper.marshallUserDefinitions(context, definitions, operation);
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[users] could not save users definitions (/DeleteUser)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{babylon.translate("userDefsError_persist", new Serializable[0])})));
        }
        return null;
    }

    private static OlapUserDefinition deleteUser(UxQueryContext context, OlapUserDefinitions definitions, String uuid) {
        OlapUserDefinition toRemove;
        List userDefinitions = definitions.getUserDefinitions();
        if (userDefinitions != null && (toRemove = UxUsersHelper.getUserDefinitionByUUID(definitions, uuid)) != null) {
            OlapTenant tenant;
            if (context.isWithMultiTenant() && (tenant = context.asRuntimeContext().getDirectoriesResolved().getTenant()) != null && !tenant.getName().equals(toRemove.getTenant())) {
                return null;
            }
            if (userDefinitions.remove(toRemove)) {
                return toRemove;
            }
            return null;
        }
        return null;
    }

    private static void marshallUserDefinitions(UxQueryContext context, OlapUserDefinitions definitions, String operation) throws JAXBException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));){
            CdXmlUtils.marshall((Writer)writer, (Object)definitions, (Class[])new Class[]{OlapUserDefinitions.class});
        }
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File dest = new File(directories.getUsersDirectory(), "icCubeUsers.icc-users");
        try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));){
            CdVFileRevActionOperation action = new CdVFileRevActionOperation(context.getUserName(), operation);
            CdVFileSystem vfs = directories.getVfs();
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.USERS, directories.getTmpDirectory(), directories.getUsersDirectory());
            vfs.saveOrUpdateWithRevision(configuration, dest, (InputStream)in, (CdVFileRevAction)action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyUserDefinitions(UxQueryContext context, InputStream in, String operation) throws UxUsersException {
        Object object = LOCK;
        synchronized (object) {
            UxUsersHelper.applyUserDefinitionsUnsafe(context, in, operation);
        }
    }

    private static void applyUserDefinitionsUnsafe(UxQueryContext context, InputStream in, String operation) throws UxUsersException {
        OlapUserDefinitions users;
        String content;
        UxBabylonService babylon = context.getUxBabylonService();
        try {
            content = IOUtils.toString((InputStream)in, (String)"UTF-8");
            users = (OlapUserDefinitions)CdXmlUtils.unmarshall((String)content, (Class[])new Class[]{OlapUserDefinitions.class});
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"users definition IO error", (Throwable)ex);
            throw UxUsersException.create(babylon, babylon.translate("userDefsError_io", new Serializable[]{ex.getMessage()}), ex);
        }
        catch (JAXBException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"invalid XML users definitions", ex);
            throw UxUsersException.create(babylon, babylon.translate("userDefsError_xml", new Serializable[0]));
        }
        IOlapAuthenticationService service = context.getAuthenticationService();
        try {
            service.refresh((IOlapUserDefinitions)users);
        }
        catch (OlapAuthenticationServiceException ex) {
            UxUsersHelper.onAuthenticationServiceException(context, ex);
            throw UxUsersException.create(babylon, babylon.translate("userDefsError_refresh", new Serializable[0]));
        }
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File dest = new File(directories.getUsersDirectory(), "icCubeUsers.icc-users");
        try (ByteArrayInputStream in_ = new ByteArrayInputStream(content.getBytes("UTF-8"));){
            CdVFileRevActionOperation action = new CdVFileRevActionOperation(context.getUserName(), operation);
            CdVFileSystem vfs = directories.getVfs();
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.USERS, directories.getTmpDirectory(), directories.getUsersDirectory());
            vfs.saveOrUpdateWithRevision(configuration, dest, (InputStream)in_, (CdVFileRevAction)action);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[users] could not persist users definitions", (Throwable)ex);
            throw UxUsersException.create(babylon, babylon.translate("userDefsError_persist", new Serializable[0]));
        }
    }

    private static UxValidationResult onAuthenticationServiceException(UxQueryContext context, OlapAuthenticationServiceException ex) {
        OlapLoggers.UX_REQUEST.error((Object)"[users] authentication service setup error(s)", (Throwable)ex);
        ArrayList<UxValidationMessage> messages = new ArrayList<UxValidationMessage>();
        List errors = ex.getErrors();
        for (String error : errors) {
            OlapLoggers.UX_REQUEST.error((Object)("[users] - " + error));
            messages.add(new UxValidationMessage("ERROR", error));
        }
        return new UxValidationResult(messages);
    }

    /*
     * Loose catch block
     */
    private static OlapUserDefinitions unmarshallUserDefinitions(UxQueryContext context, File xmlFile) throws UxUsersException {
        UxBabylonService babylon = context.getUxBabylonService();
        BufferedReader reader = null;
        String content = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-8"));
            content = IOUtils.toString((Reader)reader);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"users definition IO error", (Throwable)ex);
            throw UxUsersException.create(babylon, babylon.translate("userDefsError_io", new Serializable[]{ex.getMessage()}), ex);
        }
        OlapUserDefinitions ex = (OlapUserDefinitions)CdXmlUtils.unmarshall((String)content, (Class[])new Class[]{OlapUserDefinitions.class});
        IOUtils.closeQuietly((Reader)reader);
        return ex;
        {
            catch (JAXBException | RuntimeException ex2) {
                try {
                    OlapLoggers.UX_REQUEST.error((Object)"invalid XML users definitions", ex2);
                    throw UxUsersException.create(babylon, babylon.translate("userDefsError_xml", new Serializable[0]));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    private static OlapUserDefinition getUserDefinitionByUUID(OlapUserDefinitions definitions, String uuid) {
        List userDefinitions = definitions.getUserDefinitions();
        if (uuid == null || userDefinitions == null) {
            return null;
        }
        for (OlapUserDefinition userDefinition : userDefinitions) {
            if (!uuid.equals(userDefinition.getUUID())) continue;
            return userDefinition;
        }
        return null;
    }

    @Nullable
    private static OlapUserDefinition getUserDefinitionByName(OlapUserDefinitions definitions, boolean userNameCaseSensitive, String name) {
        List userDefinitions = definitions.getUserDefinitions();
        if (name == null || userDefinitions == null) {
            return null;
        }
        for (OlapUserDefinition userDefinition : userDefinitions) {
            String userDefinitionName = userDefinition.getName();
            if (userDefinitionName == null || !(userNameCaseSensitive ? userDefinitionName.equals(name) : userDefinitionName.equalsIgnoreCase(name))) continue;
            return userDefinition;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult deleteUserPhoto(UxQueryContext context, String uuid) {
        Object object = LOCK;
        synchronized (object) {
            return UxUsersHelper.deleteUserPhotoUnsafe(context, uuid);
        }
    }

    @Nullable
    private static UxValidationResult deleteUserPhotoUnsafe(UxQueryContext context, String uuid) {
        OlapUserDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File xml = new File(directories.getUsersDirectory(), "icCubeUsers.icc-users");
        try {
            definitions = UxUsersHelper.unmarshallUserDefinitions(context, xml);
        }
        catch (UxUsersException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{ex.getMessage()})));
        }
        OlapUserDefinition status = UxUsersHelper.deleteUserPhoto(context, definitions, uuid);
        if (status == null) {
            return null;
        }
        try {
            IOlapAuthenticationService service = context.getAuthenticationService();
            service.refresh((IOlapUserDefinitions)definitions);
        }
        catch (OlapAuthenticationServiceException ex) {
            return UxUsersHelper.onAuthenticationServiceException(context, ex);
        }
        try {
            String operation = "delete photo " + (status.getName() != null ? status.getName() : uuid);
            UxUsersHelper.marshallUserDefinitions(context, definitions, operation);
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[users] could not save users definitions (/DeleteUserPhoto)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{babylon.translate("userDefsError_persist", new Serializable[0])})));
        }
        return null;
    }

    private static OlapUserDefinition deleteUserPhoto(UxQueryContext context, OlapUserDefinitions definitions, String uuid) {
        OlapUserDefinition user;
        List userDefinitions = definitions.getUserDefinitions();
        if (userDefinitions != null && (user = UxUsersHelper.getUserDefinitionByUUID(definitions, uuid)) != null) {
            OlapTenant tenant;
            if (context.isWithMultiTenant() && (tenant = context.asRuntimeContext().getDirectoriesResolved().getTenant()) != null && !tenant.getName().equals(user.getTenant())) {
                return null;
            }
            user.setPhoto(null);
            return user;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult saveUserPhoto(UxQueryContext context, String uuid, String photoBase64) {
        Object object = LOCK;
        synchronized (object) {
            return UxUsersHelper.saveUserPhotoUnsafe(context, uuid, photoBase64);
        }
    }

    @Nullable
    private static UxValidationResult saveUserPhotoUnsafe(UxQueryContext context, String uuid, String photoBase64) {
        OlapUserDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File xml = new File(directories.getUsersDirectory(), "icCubeUsers.icc-users");
        try {
            definitions = UxUsersHelper.unmarshallUserDefinitions(context, xml);
        }
        catch (UxUsersException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{ex.getMessage()})));
        }
        OlapUserDefinition status = UxUsersHelper.saveUserPhoto(context, definitions, uuid, photoBase64);
        if (status == null) {
            return null;
        }
        try {
            IOlapAuthenticationService service = context.getAuthenticationService();
            service.refresh((IOlapUserDefinitions)definitions);
        }
        catch (OlapAuthenticationServiceException ex) {
            return UxUsersHelper.onAuthenticationServiceException(context, ex);
        }
        try {
            String operation = "edit photo " + (status.getName() != null ? status.getName() : uuid);
            UxUsersHelper.marshallUserDefinitions(context, definitions, operation);
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[users] could not save users definitions (/SaveUserPhoto)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("userDefsError", new Serializable[]{babylon.translate("userDefsError_persist", new Serializable[0])})));
        }
        return null;
    }

    private static OlapUserDefinition saveUserPhoto(UxQueryContext context, OlapUserDefinitions definitions, String uuid, String photoBase64) {
        OlapUserDefinition user;
        List userDefinitions = definitions.getUserDefinitions();
        if (userDefinitions != null && (user = UxUsersHelper.getUserDefinitionByUUID(definitions, uuid)) != null) {
            user.setPhoto(photoBase64);
            return user;
        }
        return null;
    }
}

