/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.users;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.users.UxAbstractUserQuery;
import crazydev.iccube.ux.admin.queries.users.UxUsersHelper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveUserQuery
extends UxAbstractUserQuery {
    @Nullable
    private final UxModel model;

    public UxSaveUserQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxModel model) {
        super(meta, requestId);
        this.model = model;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        int revNumber;
        OlapUserDefinition serverModel;
        UxValidationResult error;
        if (this.model == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_MISSING_DEFINITION, (Serializable[])new Serializable[0]));
        }
        boolean requiredPassword = queryContext.isUserDefinitionWithPassword();
        if (!requiredPassword) {
            queryContext.setModelTypeSetupInfo("NOT_REQUIRED_PASSWORD"::equals);
        }
        if ((error = UxUsersHelper.saveUserDefinition(queryContext, serverModel = (OlapUserDefinition)queryContext.convertToServerModel(this.model), revNumber = this.model.getRevNumber())) != null) {
            return UxReply.validationErrors(error);
        }
        return UxReply.actionSuccess();
    }
}

