/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsDashboardsVersion;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.tenants.OlapTenantUtils;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTenantsQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxTenantsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "name", "directory", "tenantHomeDirectory");
        header.add(babylon, "dashboardsVersion");
        OlapTenantManager manager = queryContext.getTenantManager();
        List tenants = manager.getSortedTenantDefinitionsForUX();
        int totalRowCount = tenants.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "name", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (OlapTenantDefinition tenant : tenants) {
            rows.add(this.createRow(queryContext, manager, tenant));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = null;
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private UxTableRow createRow(UxQueryContext context, OlapTenantManager manager, OlapTenantDefinition tenant) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxTenantQueryMeta.createUseCase(context, tenant.getUUID(), tenant.getName());
        cells.add(new UxTableCell((Object)tenant.getName(), useCase));
        cells.add(new UxTableCell(tenant.getDirectory()));
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        File home = OlapTenantUtils.getHomeDirectoryForUX((OlapDirectoriesResolved)directories, (OlapTenantDefinition)tenant);
        cells.add(new UxTableCell(home.getPath()));
        OlapDocsDashboardsVersion version = context.getActiveDashboardsVersion(tenant);
        cells.add(new UxTableCell(version != null ? version.getVersionWithTimestamp() : null));
        UxStyleLevel style = !home.exists() || home.isFile() ? UxStyleLevel.ERROR : null;
        String tooltip = style == UxStyleLevel.ERROR ? context.getUxBabylonService().translate("tenantHomeDirectoryInvalid", new Serializable[0]) : null;
        return new UxTableRow(cells).withStyle(style).withTooltip(tooltip);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Tenants));
    }
}

