/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantDefinitions;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantsException;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import org.jetbrains.annotations.Nullable;

public abstract class UxTenantsHelper {
    private static final Object LOCK = new Object();

    private UxTenantsHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult saveTenantDefinition(UxQueryContext context, OlapTenantDefinition tenant, int revNumber) throws OlapDirectoriesResolvedNotSuperAdminException {
        Object object = LOCK;
        synchronized (object) {
            return UxTenantsHelper.saveTenantDefinitionUnsafe(context, tenant, revNumber);
        }
    }

    @Nullable
    private static UxValidationResult saveTenantDefinitionUnsafe(UxQueryContext context, OlapTenantDefinition tenant, int revNumber) throws OlapDirectoriesResolvedNotSuperAdminException {
        OlapTenantDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        try {
            definitions = UxTenantsHelper.unmarshallTenantDefinitions(context, null);
        }
        catch (UxTenantsException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("tenantDefsError", new Serializable[]{ex.getMessage()})));
        }
        UxValidationResult error = UxTenantsHelper.saveOrUpdateTenant(context, definitions, tenant, revNumber);
        if (error != null) {
            return error;
        }
        try {
            UxTenantsHelper.marshallTenantDefinitions(context, definitions, "add-or-update " + tenant.getName());
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[tenant] could not save tenants definitions (/SaveTenant)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("tenantDefsError", new Serializable[]{babylon.translate("tenantDefsError_persist", new Serializable[]{ex.getMessage()})})));
        }
        OlapTenantManager service = context.getTenantManager();
        service.setTenantDefinitions(definitions);
        service.setupTenantHomeDirectory(context.getResolvedDirectories(), tenant, false);
        return null;
    }

    @Nullable
    private static UxValidationResult saveOrUpdateTenant(UxQueryContext context, OlapTenantDefinitions definitions, OlapTenantDefinition tenant, int revNumber) {
        UxBabylonService babylon = context.getUxBabylonService();
        OlapTenantManager service = context.getTenantManager();
        int currentRevNumber = service.getRevisionNumber();
        if (currentRevNumber != revNumber) {
            return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.TENANTS_REV_NUMBER_MISMATCH.asMessage(babylon, new Serializable[]{Integer.valueOf(currentRevNumber), Integer.valueOf(revNumber)})));
        }
        if (CdStringUtils.isNullOrBlank((String)tenant.getUUID())) {
            return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.TENANT_MISSING_UUID.asMessage(babylon, new Serializable[0])));
        }
        if (CdStringUtils.isNullOrBlank((String)tenant.getName())) {
            return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.TENANT_MISSING_NAME.asMessage(babylon, new Serializable[0])));
        }
        OlapTenantDefinition existingTenant = definitions.getTenantDefinitionByUUID(tenant.getUUID());
        if (existingTenant == null) {
            if (definitions.getTenantDefinitionByName(tenant.getName()) != null) {
                return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.TENANT_DUPLICATED.asMessage(babylon, new Serializable[]{tenant.getName()})));
            }
            definitions.addTenantDefinition(tenant);
        } else {
            if (!tenant.getName().equals(existingTenant.getName()) && definitions.getTenantDefinitionByName(tenant.getName()) != null) {
                return new UxValidationResult(new UxValidationMessage("ERROR", UxErrorCode.TENANT_DUPLICATED.asMessage(babylon, new Serializable[]{tenant.getName()})));
            }
            definitions.replaceTenantDefinition(tenant);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UxValidationResult deleteTenantDefinition(UxQueryContext context, String uuid) throws OlapDirectoriesResolvedNotSuperAdminException {
        Object object = LOCK;
        synchronized (object) {
            return UxTenantsHelper.deleteTenantDefinitionUnsafe(context, uuid);
        }
    }

    @Nullable
    private static UxValidationResult deleteTenantDefinitionUnsafe(UxQueryContext context, String uuid) throws OlapDirectoriesResolvedNotSuperAdminException {
        OlapTenantDefinitions definitions;
        UxBabylonService babylon = context.getUxBabylonService();
        try {
            definitions = UxTenantsHelper.unmarshallTenantDefinitions(context, null);
        }
        catch (UxTenantsException ex) {
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("tenantDefsError", new Serializable[]{ex.getMessage()})));
        }
        OlapTenantDefinition deletedTenant = definitions.deleteTenantByUUID(uuid);
        if (deletedTenant == null) {
            return null;
        }
        try {
            UxTenantsHelper.marshallTenantDefinitions(context, definitions, "delete " + deletedTenant.getName());
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[tenant] could not save tenants definitions (/DeleteTenant)", ex);
            return new UxValidationResult(new UxValidationMessage("ERROR", babylon.translate("tenantDefsError", new Serializable[]{babylon.translate("tenantDefsError_persist", new Serializable[]{ex.getMessage()})})));
        }
        OlapTenantManager service = context.getTenantManager();
        service.setTenantDefinitions(definitions);
        service.deleteTenantHomeDirectory(context.getResolvedDirectories(), deletedTenant);
        return null;
    }

    private static OlapTenantDefinitions unmarshallTenantDefinitions(UxQueryContext context, @Nullable File xmlFile) throws UxTenantsException, OlapDirectoriesResolvedNotSuperAdminException {
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        directories.assertRoot();
        File tenants = directories.getTenantsDirectory();
        File file = xmlFile == null ? new File(tenants, "icCubeTenants.icc-tenants") : xmlFile;
        try {
            OlapTenantDefinitions tenantDefinitions = (OlapTenantDefinitions)CdXmlUtils.unmarshall((String)"UTF-8", (File)file, (Class[])new Class[]{OlapTenantDefinitions.class});
            return tenantDefinitions;
        }
        catch (JAXBException | IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[tenant] invalid XML tenants definitions", ex);
            throw UxTenantsException.create(babylon, babylon.translate("tenantDefsError_xml", new Serializable[0]));
        }
    }

    private static void marshallTenantDefinitions(UxQueryContext context, OlapTenantDefinitions definitions, String operation) throws JAXBException, IOException, OlapDirectoriesResolvedNotSuperAdminException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));){
            CdXmlUtils.marshall((Writer)writer, (Object)definitions, (Class[])new Class[]{OlapTenantDefinitions.class});
        }
        UxTenantsHelper.marshallTenantDefinitions(context, out, operation);
    }

    private static void marshallTenantDefinitions(UxQueryContext context, ByteArrayOutputStream out, String operation) throws IOException, OlapDirectoriesResolvedNotSuperAdminException {
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        directories.assertRoot();
        File dest = new File(directories.getTenantsDirectory(), "icCubeTenants.icc-tenants");
        try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));){
            CdVFileRevActionOperation action = new CdVFileRevActionOperation(context.getUserName(), operation);
            CdVFileSystem vfs = directories.getVfs();
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.TENANTS, directories.getTmpDirectory(), directories.getMultiTenantDirectory());
            vfs.saveOrUpdateWithRevision(configuration, dest, (InputStream)in, (CdVFileRevAction)action);
        }
    }
}

