/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.tenants.UxAbstractTenantQuery;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantsFileQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;

public class UxTenantsFileQuery
extends UxAbstractTenantQuery {
    public UxTenantsFileQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        OlapDirectoriesResolved directories = queryContext.getResolvedDirectories();
        File tenants = directories.getTenantsDirectory();
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)tenants);
        OlapFile file = fs.create("icCubeTenants.icc-tenants");
        String mimeType = queryContext.getMimeTypeByExtension(file.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file, file.getName(), mimeType, false);
        UxAction save = null;
        return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper, save);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxTenantsFileQueryMeta.createUseCase(queryContext));
    }
}

