/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.iccube.ux.admin.queries.tenants.UxAbstractTenantQueryMeta;
import crazydev.iccube.ux.admin.queries.tenants.UxDeleteTenantQueryMeta;
import crazydev.iccube.ux.admin.queries.tenants.UxRepairTenantHomeDirectoryQueryMeta;
import crazydev.iccube.ux.admin.queries.tenants.UxSetupTenantHomeDirectoryQueryMeta;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantQuery;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTenantQueryMeta
extends UxAbstractTenantQueryMeta {
    public static final UxTenantQueryMeta Tenant = new UxTenantQueryMeta();

    protected UxTenantQueryMeta() {
        super(UxConsoleConstants.QueryName.Tenant);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String uuid = params.getStringParameter("uuid");
        return new UxTenantQuery(this, params.getRequestId(), uuid);
    }

    public UxUrl createQueryUrl(String uuid) {
        return this.createQueryUrl().addParam("uuid", uuid);
    }

    public static UxUseCase createUseCase(UxQueryContext context, @Nullable String uuid, @Nullable String name) {
        List<UxAction> actions = Tenant.createActions(context);
        if (uuid != null) {
            actions.add(UxSetupTenantHomeDirectoryQueryMeta.createAction(context, uuid));
            actions.add(UxRepairTenantHomeDirectoryQueryMeta.createAction(context, uuid));
            actions.add(UxDeleteTenantQueryMeta.createAction(context, uuid, name));
        }
        return new UxUseCaseBuilder(context, Tenant).withId(UxAdminUseCaseName.Tenant).withUrl(Tenant.createQueryUrl(uuid)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Tenants), uuid, name, UxAdminUseCaseRepository.asBookmark(Tenant.createQueryUrl(uuid)))).withActions(actions).build(true);
    }
}

