/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.admin.queries.tenants.UxAbstractTenantQuery;
import crazydev.iccube.ux.admin.queries.tenants.UxSaveTenantQueryMeta;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxTenantQuery
extends UxAbstractTenantQuery {
    @Nullable
    private final String uuid;
    @Nullable
    private OlapTenantDefinition tenant;

    public UxTenantQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_UNKNOWN, (Serializable[])new Serializable[]{""}));
        }
        OlapTenantManager tenants = queryContext.getTenantManager();
        int revNumber = tenants.getRevisionNumber();
        this.tenant = tenants.getTenantDefinitionByUUID(this.uuid);
        if (this.tenant == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        UxModel model = queryContext.convertToUxModel(revNumber, this.tenant);
        UxAction save = UxSaveTenantQueryMeta.createAction(queryContext, false, this.tenant.getUUID(), this.tenant.getName());
        return UxReply.success(new UxModelReplyPayload(model, save));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxTenantQueryMeta.createUseCase(queryContext, this.uuid, this.tenant != null ? this.tenant.getName() : null));
    }
}

