/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.ux.admin.queries.tenants.UxAbstractTenantQuery;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantsHelper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveTenantQuery
extends UxAbstractTenantQuery {
    @Nullable
    private final UxModel model;

    public UxSaveTenantQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxModel model) {
        super(meta, requestId);
        this.model = model;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (!queryContext.isSuperAdministrator()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_NOT_GLOBAL_ADMINISTRATOR, (Serializable[])new Serializable[0]));
        }
        try {
            int revNumber;
            if (this.model == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_MISSING_DEFINITION, (Serializable[])new Serializable[0]));
            }
            OlapTenantDefinition serverModel = (OlapTenantDefinition)queryContext.convertToServerModel(this.model);
            UxValidationResult error = UxTenantsHelper.saveTenantDefinition(queryContext, serverModel, revNumber = this.model.getRevNumber());
            if (error != null) {
                return UxReply.validationErrors(error);
            }
            return UxReply.actionSuccess();
        }
        catch (OlapDirectoriesResolvedNotSuperAdminException ex) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_NOT_GLOBAL_ADMINISTRATOR, (Serializable[])new Serializable[0]));
        }
    }
}

